---
name: mcp-postgres-query-agent
version: 1.0.0
description: Connect AI assistants to PostgreSQL databases via MCP for queries, schema inspection, optimization, and health analysis
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill helps you set up a PostgreSQL MCP Server to connect AI assistants to your PostgreSQL database. Supports both Postgres MCP Pro (full-featured, 9 tools) and the official reference server (read-only, 3 tools).

**Time to initialize**: ~5 minutes

## Directory Structure

```
mcp-postgres-query-agent/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization manifest
```

## Dependencies

None (prompt-only skill). The PostgreSQL MCP Server requires:
- Docker OR Python 3.12+ (for Postgres MCP Pro)
- Node.js 18+ (for official reference server via NPX)
- PostgreSQL connection credentials

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Option A: Postgres MCP Pro (Recommended)

```bash
# Install via Docker
docker pull crystaldba/postgres-mcp

# Or via Python
pipx install postgres-mcp
```

**Claude Desktop config** (`~/Library/Application Support/Claude/claude_desktop_config.json`):
```json
{
  "mcpServers": {
    "postgres": {
      "command": "docker",
      "args": ["run", "-i", "--rm", "-e", "DATABASE_URI", "crystaldba/postgres-mcp", "--access-mode=restricted"],
      "env": {
        "DATABASE_URI": "postgresql://user:password@host:5432/dbname"
      }
    }
  }
}
```

### Option B: Official Reference Server

```json
{
  "mcpServers": {
    "postgres": {
      "command": "npx",
      "args": ["-y", "@modelcontextprotocol/server-postgres", "postgresql://user:password@host:5432/dbname"]
    }
  }
}
```

### Enable Extensions (Optional but Recommended)

```sql
CREATE EXTENSION IF NOT EXISTS pg_stat_statements;
CREATE EXTENSION IF NOT EXISTS hypopg;
```

## Compatibility

Tested with: Claude Desktop, Claude Code, Cursor, VS Code Copilot, Windsurf

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{database_workflow}}` | `querying data and optimizing slow queries` | Primary workflow |
| `{{database_uri}}` | `postgresql://user:password@localhost:5432/mydb` | Connection string |
| `{{access_mode}}` | `restricted (read-only)` | Access level |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
