---
name: mcp-slack-connector
version: 1.0.0
description: Connect AI assistants to Slack workspaces via MCP for channels, messages, threads, and user management
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill helps you set up the Slack MCP Server to connect AI assistants to your Slack workspace. Once configured, you can use natural language to read channels, post messages, manage threads, and interact with users.

**Time to initialize**: ~5 minutes (includes Slack App creation)

## Directory Structure

```
mcp-slack-connector/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization manifest
```

## Dependencies

None (prompt-only skill). The Slack MCP Server requires:
- Node.js 18+ (for NPX) OR Docker
- A Slack Bot Token (`xoxb-...`)
- Your Slack Team ID (`T...`)

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Post-Init Steps

### 1. Create Slack App
1. Go to https://api.slack.com/apps → "Create New App" → "From scratch"
2. Add OAuth scopes: `channels:history`, `channels:read`, `chat:write`, `reactions:write`, `users:read`
3. Install to workspace and copy Bot Token

### 2. Configure MCP Client

**Claude Desktop** (`~/Library/Application Support/Claude/claude_desktop_config.json`):
```json
{
  "mcpServers": {
    "slack": {
      "command": "npx",
      "args": ["-y", "@modelcontextprotocol/server-slack"],
      "env": {
        "SLACK_BOT_TOKEN": "xoxb-your-token",
        "SLACK_TEAM_ID": "T01234567"
      }
    }
  }
}
```

**Claude Code**:
```bash
claude mcp add-json slack '{"command":"npx","args":["-y","@modelcontextprotocol/server-slack"],"env":{"SLACK_BOT_TOKEN":"xoxb-your-token","SLACK_TEAM_ID":"T01234567"}}'
```

### 3. Invite Bot to Channels
```
/invite @YourBotName
```

## Compatibility

Tested with: Claude Desktop, Claude Code, VS Code Copilot, Cursor

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{slack_workflow}}` | `monitoring channels and summarizing discussions` | Primary workflow |
| `{{workspace_scope}}` | `general, engineering, product` | Channels to access |
| `{{bot_permissions}}` | `read and write messages` | Permission level |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
