---
name: mcp-stripe-payments
version: 1.0.0
description: Connect AI assistants to Stripe via the official MCP server for payments, billing, and customer management
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill helps you set up the official Stripe MCP server to connect AI assistants to your Stripe account. Supports 27 tools for customers, products, subscriptions, invoices, payments, refunds, coupons, and disputes.

**Time to initialize**: ~5 minutes

## Directory Structure

```
mcp-stripe-payments/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization manifest
```

## Dependencies

None (prompt-only skill). The Stripe MCP server requires:
- Stripe account (test or live mode)
- API key or OAuth access

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Remote Server (Recommended)

**Claude Code:**
```bash
claude mcp add --transport http stripe https://mcp.stripe.com/
claude /mcp  # Authenticate
```

**Claude Desktop:**
```json
{
  "mcpServers": {
    "stripe": {
      "command": "npx",
      "args": ["-y", "@stripe/mcp", "--tools=all", "--api-key=sk_test_..."]
    }
  }
}
```

### Local Server

```bash
npx -y @stripe/mcp --tools=all --api-key=sk_test_your_key
```

## Compatibility

Tested with: Claude Desktop, Claude Code, Cursor, VS Code Copilot, Windsurf

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{stripe_workflow}}` | `managing subscriptions and processing refunds` | Primary workflow |
| `{{auth_method}}` | `OAuth for security, restricted API key for agents` | Auth method |
| `{{stripe_mode}}` | `test mode for development` | Environment |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
