---
name: mcp-supabase-toolkit
version: 1.0.0
description: Connect AI assistants to Supabase via the official MCP server for database management, edge functions, and debugging
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill helps you set up the official Supabase MCP server to connect AI assistants to your Supabase projects. Supports 30+ tools for database management, edge functions, branching, debugging, and project administration.

**Time to initialize**: ~5 minutes

## Directory Structure

```
mcp-supabase-toolkit/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization manifest
```

## Dependencies

None (prompt-only skill). The Supabase MCP server is hosted — no local installation needed.

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Hosted Server (Recommended)

Add to your AI client's MCP configuration:
```json
{
  "mcpServers": {
    "supabase": {
      "type": "http",
      "url": "https://mcp.supabase.com/mcp"
    }
  }
}
```

On first connection, authenticate via browser with your Supabase account.

### Configuration Options

- Read-only: `?read_only=true`
- Project-scoped: `?project_ref=your-project-id`
- Feature-limited: `?features=database,docs,debugging`

## Compatibility

Tested with: Claude Desktop, Claude Code, Cursor, VS Code Copilot, Windsurf

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{supabase_workflow}}` | `database queries, schema design, and edge function deployment` | Primary workflow |
| `{{project_scope}}` | `development project only (never production)` | Project scope |
| `{{access_mode}}` | `read-write for development, read-only for staging` | Access level |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
