---
name: meeting-facilitator
version: 1.0.0
---

# Initialization

Run effective meetings with proven facilitation techniques, structured agendas, and decision frameworks. Get actionable outcomes from every standup, brainstorm, retrospective, decision-making meeting, one-on-one, and all-hands.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with full facilitation instructions, 6 meeting templates, 8 facilitation techniques, 5 problem-solution guides, remote/hybrid best practices, and follow-up templates

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r meeting-facilitator/ ~/.claude/skills/meeting-facilitator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{my_meeting_type}}` | `` | Type of meeting (standup, brainstorm, decision-making, retrospective, 1-on-1) |
| `{{my_team_size}}` | `` | Team size or number of attendees |
| `{{my_meeting_challenge}}` | `` | Biggest challenge (going off-topic, no decisions, dominant voices) |
| `{{my_format}}` | `remote` | Meeting format (in-person, remote, hybrid) |

## Skill Content Summary

### Meeting Type Templates Included
1. **Daily Standup / Sync** (15 min) - Round robin with blocker resolution
2. **Brainstorming Session** (45-60 min) - Silent brainstorming, 1-2-4-All, dot voting
3. **Decision-Making Meeting** (30-45 min) - RACI, fist of five, disagree-and-commit
4. **Retrospective** (60 min) - Start-Stop-Continue, 4Ls, Sailboat formats
5. **One-on-One** (25-30 min) - Coaching questions, SBI feedback model
6. **All-Hands / Town Hall** (45-60 min) - Strategic update, Q&A, hybrid tips

### Facilitation Techniques Included
1. **1-2-4-All** (Liberating Structures) - Progressive idea building
2. **Round Robin** - Equal voice for all participants
3. **Silent Brainstorming** (Brainwriting) - Eliminates groupthink
4. **Dot Voting** - Quick prioritization of many options
5. **Fist of Five** - Graduated consensus checking
6. **Parking Lot** - Capture off-topic items without derailing
7. **World Cafe** - Cross-pollinate ideas across groups
8. **Fishbowl Discussion** - Deep discussion in large groups

### Problem-Solution Guides
- Dominant voices
- Silent participants
- Meetings that run over
- No decisions made
- Going off-topic

### Frameworks Referenced
- 5 Ps Framework (Purpose, Participants, Process, Payoff, Preparation)
- RACI (Responsible, Accountable, Consulted, Informed)
- Liberating Structures
- SBI Feedback Model (Situation, Behavior, Impact)
- Disagree and Commit
- Gradients of Agreement

### Additional Content
- Remote and hybrid meeting best practices
- Energy management for long meetings
- Meeting anti-patterns cheat sheet (10 anti-patterns)
- Action item formula (What, Who, When, Where)
- Meeting notes template
- Follow-up and accountability system

## Research Sources

- Liberating Structures for Effective Collaboration (Scrum.org)
- How to Design an Agenda for an Effective Meeting (Harvard Business Review)
- Decision-Making Techniques for Facilitators (Kaizenko)
- Best Practices for Hybrid Meetings (University of Toronto)
- Fist to Five Consensus Method (SessionLab)
- Meeting Facilitation Techniques (Remote Sparks)
- 12 Common Meeting Challenges and Solutions (Oliv.ai)
- Handling Dominant Voices in Meetings (North Star Facilitators)

---
Downloaded from [Find Skill.ai](https://findskill.ai)
