---
name: car-repair-vs-replace
version: 1.0.0
---

# Car Repair vs. Replace Decision Calculator

Make data-driven car repair or replacement decisions using professional financial analysis frameworks: the 50% Rule, Monthly Payment Equivalent, Break-Even Analysis, and Total Cost of Ownership calculations.

## Package Structure

```
car-repair-vs-replace/
├── SKILL.md    # Main skill prompt (copy this to your AI)
└── INIT.md     # This initialization file
```

## Files to Generate

None required. This is a prompt-only skill.

## Post-Init Steps

### For Claude Code Users

```bash
# Copy skill to Claude Code skills directory
cp -r car-repair-vs-replace/ ~/.claude/skills/car-repair-vs-replace/
```

Then reference in your CLAUDE.md:
```markdown
## Available Skills
- `car-repair-vs-replace` - Vehicle repair/replace financial analysis
```

### For ChatGPT / Gemini / Copilot Users

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or custom instructions
4. Start your conversation with your vehicle details

### Quick Start Prompt

After installing, use this prompt to get started:

```
I have a 2012 Honda Accord with 160k miles worth about $5,000. The transmission just failed and the shop wants $2,800 to fix it. I've spent $500 on other repairs this year. A replacement car would cost me $400/month. Should I fix it or buy a new one?
```

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `current_repair_estimate` | `0` | Quote for the immediate repair needed |
| `vehicle_market_value` | `0` | KBB Private Party value if car were running |
| `monthly_replacement_cost` | `500` | Monthly payment for a replacement vehicle |
| `insurance_increase` | `50` | Monthly insurance premium increase for newer car |
| `months_life_extension` | `6` | Mechanic's estimate of additional months post-repair |
| `past_year_repair_total` | `0` | Total spent on unexpected repairs last 12 months |

## Key Features

- **50% Rule**: Quick assessment comparing repair cost to vehicle value
- **Monthly Payment Equivalent**: Cash flow comparison of repair vs. replacement
- **Break-Even Analysis**: How long the car must last to justify repair
- **Total Cost of Ownership**: 3-5 year comprehensive comparison
- **Sunk Cost Awareness**: Helps users avoid emotional decision traps
- **Special Scenarios**: Gig drivers, underwater loans, emotional attachment

## Example Interactions

### Example 1: Transmission Failure
```
User: My 2015 Camry needs a $3,500 transmission. Worth $8,000. What do I do?

AI: Running analysis...
- 50% Rule: 43.75% - Lean Repair zone
- Break-Even: 7.8 months at $450/month replacement cost
- Recommendation: REPAIR with medium-high confidence
```

### Example 2: Nickel-and-Dime Frustration
```
User: I've spent $400 on brakes, $600 on tires, $300 coolant leak, now $1,100 AC. Is this a money pit?

AI: Let me separate maintenance from repairs...
- Brakes + Tires = $1,000 (normal maintenance, would need on ANY car)
- Coolant + AC = $1,400 (actual repairs)
- Monthly repair average: $117/month
- This is NOT a money pit - it's normal aging
```

## Troubleshooting

**Q: User doesn't know the car's value**
A: Direct them to KBB.com → Private Party value, or estimate based on year/make/model/mileage

**Q: Math shows repair and replace are nearly equal**
A: Use tiebreakers: reliability anxiety level, budget flexibility, known vs. unknown devil

**Q: User already emotionally decided**
A: Calculate "cost of preference" so they make an informed choice

## Related Skills

- [Major Purchase Research Advisor](/skills/productivity/major-purchase-advisor/) - Evaluate replacement options
- [Budget Planner](/skills/productivity/budget-planner/) - Fit car expenses into budget
- [Debt Payoff Calculator](/skills/productivity/debt-payoff-calculator/) - Plan car loan payoff
- [Bill Negotiation Scripts](/skills/productivity/bill-negotiation-scripts/) - Negotiate with mechanics

---
Downloaded from [Find Skill.ai](https://findskill.ai)
