# Financial Goal Tracker

A comprehensive AI skill for setting, tracking, and achieving financial goals using the SMART framework, progress visualization, and behavioral psychology principles.

## Overview

This skill transforms vague financial wishes into concrete, trackable goals with clear timelines and progress markers. It helps users prioritize multiple goals, calculate monthly contributions, visualize progress, and celebrate milestones along the way.

## Key Features

### 1. SMART Goal Framework
- **Specific**: Convert vague goals into precise targets
- **Measurable**: Define exact amounts and metrics
- **Achievable**: Reality-check timelines against contribution capacity
- **Relevant**: Prioritize based on values and life stage
- **Time-bound**: Set concrete deadlines

### 2. Goal Prioritization
- Financial Goals Priority Pyramid (Foundation to Lifestyle)
- Emergency fund sizing calculator
- Priority matrix for competing goals
- Bucket system for organizing multiple goals

### 3. Monthly Contribution Calculator
- Savings capacity analysis
- Contribution allocation strategies:
  - Priority-based (sequential)
  - Proportional (parallel)
  - Milestone-based (hybrid)

### 4. Progress Tracking
- Visual dashboard templates
- Multiple progress bar styles
- Monthly check-in templates
- Goal achievement documentation

### 5. Milestone Celebrations
- Structured celebration framework (10%, 25%, 50%, 75%, 100%)
- Budget-conscious reward suggestions
- Achievement certificates
- Reflection prompts

### 6. Goal Adjustment Strategies
- When and how to adjust goals
- Adjustment options (extend, reduce, increase, pause, abandon)
- Documentation templates
- Setback recovery protocol

### 7. Multiple Goal Balancing
- Bucket approach (Security, Future, Near-term, Enjoyment)
- Goal competition decision matrix
- Sequential vs parallel funding strategies

### 8. Behavioral Strategies
- Automation setup guide
- Goal gradient effect leverage
- Savings protection strategies
- Setback recovery

## Supported Goal Types

- Emergency funds (3-6 months expenses)
- House down payments
- Retirement savings
- Vacation funds
- Car replacement
- Education savings
- Debt payoff acceleration
- Major purchases
- Wedding funds
- Starting a business

## Usage Examples

### Basic Goal Setup
```
"I want to save $10,000 for an emergency fund. I currently have $2,000
saved and can put away $500/month. Help me track this goal."
```

### Multiple Goals
```
"I need to balance saving for a $25,000 house down payment, a $3,000
vacation next summer, and building my emergency fund to $15,000.
My monthly savings capacity is $1,200. How should I prioritize?"
```

### Goal Adjustment
```
"I was saving $600/month for my emergency fund but just had my hours
cut. Now I can only do $350/month. Help me adjust my plan."
```

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `my_savings_goal` | "Emergency Fund" | Name of the primary savings goal |
| `my_target_amount` | "10000" | Target amount in local currency |
| `my_monthly_contribution` | "500" | Monthly contribution amount |
| `my_current_savings` | "2000" | Amount already saved |
| `my_currency_symbol` | "$" | Currency symbol to use |

## Best Practices

1. **Start with Foundation**: Ensure emergency fund basics before other goals
2. **Automate Everything**: Set up automatic transfers for each goal
3. **Name Your Accounts**: Specific names increase psychological commitment
4. **Celebrate Milestones**: Planned celebrations maintain motivation
5. **Review Monthly**: Regular check-ins catch issues early
6. **Adjust Without Guilt**: Life changes; goals should too
7. **Visualize Progress**: Keep trackers visible for motivation

## Related Skills

- **Budget Planner**: Create budgets that allocate toward goals
- **Spending Pattern Analyzer**: Find money to redirect to goals
- **Debt Payoff Calculator**: Clear debt faster for more savings
- **Net Worth Tracker**: Track overall financial progress
- **Financial Independence Calculator**: Long-term FIRE planning

## Limitations

- Provides general guidance, not personalized financial advice
- Does not account for taxes on savings interest
- Investment return projections are estimates only
- Cannot predict life changes that affect savings capacity

## Notes

- Uses first-person framing for variables ("My savings goal")
- Emphasizes behavioral psychology for sustained motivation
- Focuses on achievable progress over perfection
- Includes recovery strategies for setbacks
