---
name: late-fee-negotiator
version: 1.0.0
---

# Initialization

Expert system for negotiating late fees and overdraft charges with banks. Provides customized phone scripts, escalation tactics, and success probability assessments based on your account history and the specific bank's policies.

## Structure

- `SKILL.md` - Main skill prompt with scripts, tactics, and bank-specific strategies

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r late-fee-negotiator/ ~/.claude/skills/late-fee-negotiator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `fee_type` | `late fee` | Type of fee (late fee, overdraft, interest charge) |
| `fee_amount` | `35` | Dollar amount of the fee |
| `bank_name` | `` | Name of the bank or credit card company |
| `account_age_years` | `3` | How long you've been a customer |
| `last_late_payment_months` | `24` | Months since your last late payment |
| `payment_history` | `excellent` | Payment history quality (excellent, good, fair) |

## Quick Start

Provide these details to the AI:
1. Fee type and amount
2. Bank name
3. Account age
4. Time since last late payment
5. Whether you've made the late payment already

The AI will assess your success probability and provide a customized script.

## Example Usage

"I got a $39 late fee on my Chase credit card. I've been a customer for 6 years and this is my first late payment. I already paid the balance. Help me get this waived."

## Success Rates by Scenario

| Scenario | Expected Success |
|----------|------------------|
| First-time late fee, 2+ year customer | 85-95% |
| First-time in 6-12 months | 60-80% |
| Second waiver request in 12 months | 40-60% |
| Multiple overdraft fees (system error) | 70-80% |
| Interest charge waiver | 30-40% |

---

Downloaded from [Find Skill.ai](https://findskill.ai)
