---
name: pet-affordability-calculator
version: 1.0.0
---

# Initialization

The Pet Affordability Calculator helps prospective pet owners determine if they can truly afford a dog by analyzing discretionary surplus against real ownership costs. It goes beyond simple adoption fee estimates to include insurance, preventatives, pet rent, grooming, and lifestyle-driven expenses like dog walkers and boarding.

## Structure

```
pet-affordability-calculator/
├── SKILL.md    # Main skill prompt (500+ lines)
└── INIT.md     # This file
```

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code

```bash
cp -r pet-affordability-calculator/ ~/.claude/skills/pet-affordability-calculator/
```

Then reference in your project's CLAUDE.md:

```markdown
## Available Skills
- pet-affordability-calculator: Financial analysis for prospective pet owners
```

### ChatGPT / Custom GPT

1. Open `SKILL.md`
2. Copy all content after the `---` frontmatter closing
3. Paste into Custom GPT instructions or conversation

### Gemini

1. Open `SKILL.md`
2. Copy the skill content
3. Use as system prompt or paste at conversation start

### Other AI Assistants

1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into your AI assistant's instruction field

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{dog_size}}` | `medium` | Size category: small (<20 lbs), medium (20-50 lbs), large (50-90 lbs), giant (90+ lbs) |
| `{{location_col}}` | `medium` | Cost of living tier: low, medium, high, vhcol |
| `{{grooming_needs}}` | `low` | Grooming frequency: low (owner brushes), medium, high (professional monthly) |
| `{{lifestyle_activity}}` | `homebody` | Work patterns: homebody, hybrid, office, traveler |
| `{{insurance_tier}}` | `standard` | Coverage level: none, accident_only, standard, premium |
| `{{monthly_income}}` | `0` | User's monthly net take-home pay (required for calculations) |

## Quick Start Prompts

After installing, try these prompts:

**Basic Affordability Check:**
```
I make $4,000/month take-home with $3,200 in fixed expenses.
Can I afford a medium-sized dog in Denver?
```

**Breed Comparison:**
```
Compare the monthly costs of owning a French Bulldog vs. a Labrador Retriever vs. a shelter mutt.
```

**Emergency Simulation:**
```
What happens to my finances if my dog needs a $4,000 surgery?
I have $3,000 saved and standard pet insurance with a $500 deductible.
```

**Hidden Cost Reveal:**
```
I work in an office 5 days/week and travel 3 weeks per year.
What are the hidden lifestyle costs of dog ownership I'm probably missing?
```

## Key Features

1. **Surplus Analysis** - Calculates true discretionary income available for pet costs
2. **Location Adjustment** - Scales costs by geographic cost of living (VHCOL to LCOL)
3. **Breed Risk Factors** - Applies health risk multipliers by breed
4. **Emergency Simulations** - Models out-of-pocket costs for common emergencies
5. **Lifestyle Stress Tests** - Reveals hidden costs from work schedules and travel
6. **Day 1 Readiness** - Calculates startup costs and emergency fund requirements

## Troubleshooting

**"The costs seem too high"**
- Costs are based on 2024 industry data and real owner reports
- Verify your location tier is correct (VHCOL cities cost 1.5-2x more)
- Check if you're looking at premium vs. budget options

**"I didn't get a clear verdict"**
- Ensure you provided monthly income and expenses
- The skill needs financial data to calculate surplus

**"My breed isn't listed"**
- Ask the AI to estimate based on similar breeds
- Provide the dog's size and any known health concerns

---
Downloaded from [Find Skill.ai](https://findskill.ai)
