# INIT.md -- Persuasion Framework Builder

## Skill Manifest

This file contains everything needed to recreate the Persuasion Framework Builder skill from scratch. Another AI agent can read this file alone and produce the complete skill package.

## Metadata

| Field | Value |
|-------|-------|
| **Title** | Persuasion Framework Builder |
| **Slug** | persuasion-framework-builder |
| **Category** | communication |
| **Difficulty** | advanced |
| **Platforms** | claude, chatgpt, gemini, copilot |
| **Date** | 2026-02-04 |
| **Rating** | 4.5 |
| **Downloads** | 870 |
| **Time to Implement** | 15 min |
| **Tags** | persuasion, communication, influence, sales, copywriting, rhetoric, negotiation, frameworks |

## Purpose

Build compelling, ethical persuasive arguments using proven frameworks. The skill covers classical rhetoric (Aristotle), modern psychology (Cialdini), and copywriting frameworks (AIDA, PAS, BAB, 4Ps, Monroe's Motivated Sequence). It selects the optimal framework based on the user's situation and builds a complete argument structure.

## Variables

| Variable | Description | Default |
|----------|-------------|---------|
| `my_message` | My core message or what I want to persuade someone of | (empty) |
| `my_audience` | My target audience | (empty) |
| `my_medium` | My communication medium (email, presentation, proposal, essay, ad copy) | (empty) |
| `my_resistance` | My audience's likely objections or resistance points | (empty) |

## Core Skill Content

The skill prompt establishes the AI as a Persuasion Framework Builder that:

1. Gathers four inputs: core message, target audience, medium, and resistance points
2. Contains a complete framework library with five frameworks (AIDA, PAS, BAB, 4Ps, Monroe's Motivated Sequence) including structure diagrams, best-use cases, and worked examples
3. Covers Cialdini's seven principles of influence (Reciprocity, Commitment/Consistency, Social Proof, Authority, Liking, Scarcity, Unity) with application templates
4. Covers Aristotle's four rhetorical appeals (Ethos, Pathos, Logos, Kairos) with technique tables and building strategies
5. Provides a framework selection matrix mapping communication types, audience profiles, and resistance types to optimal frameworks
6. Includes comprehensive objection handling patterns with response templates
7. Covers storytelling in persuasion with a six-part narrative structure
8. Provides emotional vs. rational appeal balance guidelines by audience type
9. Includes call to action templates for every medium
10. Defines ethical persuasion boundaries with a five-point ethics test and red lines
11. Covers industry-specific persuasion for internal proposals, sales, fundraising, policy/advocacy, and marketing
12. Lists ten anti-patterns to avoid

## Key Frameworks Detail

### AIDA (Attention - Interest - Desire - Action)
- Origin: E. St. Elmo Lewis (1890s), refined by Edward Strong (1925)
- Best for: Sales pages, marketing emails, product pitches, advertisements, cold outreach
- Structure: Hook attention, spark curiosity, create emotional pull, clear single-step CTA

### PAS (Problem - Agitate - Solve)
- Origin: Direct-response copywriting tradition, popularized by Dan Kennedy
- Best for: Sales emails, landing pages, change proposals, fundraising
- Structure: Name the pain specifically, amplify urgency through cost of inaction, present solution as relief

### BAB (Before - After - Bridge)
- Origin: Email marketing and storytelling tradition
- Best for: Short-form content, transformation narratives, case studies
- Structure: Paint current painful reality, paint desired future, show path between them

### 4Ps (Promise - Picture - Proof - Push)
- Origin: Classic direct-response copywriting
- Best for: Social media, testimonial campaigns, product launches, crowdfunding
- Structure: Bold specific benefit, vivid scene of success, evidence, urgent CTA

### Monroe's Motivated Sequence
- Origin: Alan H. Monroe, Purdue University (1930s)
- Best for: Speeches, board presentations, policy arguments, persuasive essays, change management
- Structure: Hook attention, establish problem/need, present solution, visualize outcome, specific action call

### Cialdini's Seven Principles
- Reciprocity: Give first to create obligation
- Commitment/Consistency: Build on prior agreements and stated values
- Social Proof: Show others (especially peers) already doing it
- Authority: Cite credible experts and authoritative sources
- Liking: Build rapport through similarity, compliments, cooperation
- Scarcity: Highlight limited availability and opportunity cost (only real scarcity)
- Unity: Emphasize shared identity and in-group belonging

### Aristotle's Rhetorical Appeals
- Ethos: Credibility through competence, character, and goodwill
- Pathos: Emotional connection to audience's genuine feelings
- Logos: Evidence hierarchy from meta-analyses to anecdotes
- Kairos: Right message, right moment, right context

## Response Format

The skill outputs in this structure:
1. Situation Analysis (message, audience, medium, resistance)
2. Recommended Framework with rationale
3. Framework Application (full structured argument)
4. Rhetorical Balance (ethos, pathos, logos, kairos strategies)
5. Cialdini Principles in Play (2-3 most relevant)
6. Objection Handling table
7. Story (optional, when narrative strengthens the case)
8. Call to Action (primary, backup, follow-up)
9. Complete Draft (ready to use)
10. Ethics Check (five-point verification)

## Ethical Boundaries (Non-Negotiable)

The skill enforces five ethics tests:
1. **Transparency Test**: Would you be comfortable if the audience knew your technique?
2. **Reversibility Test**: Would you accept this approach used on you?
3. **Interest Test**: Does this serve the audience's interests alongside yours?
4. **Autonomy Test**: Are you improving their decision-making, not bypassing it?
5. **Long-Term Test**: Will this build or erode trust?

Red lines: No fabricated statistics, no false scarcity, no fear exploitation, no suppressed counter-evidence, no manipulation of vulnerable people, no broken promises, no fake testimonials, no impersonated authority, no pressure past a clear "no."

## Research Sources

| Source | URL |
|--------|-----|
| Cialdini's Principles - CXL | https://cxl.com/blog/cialdinis-principles-persuasion/ |
| Aristotle's Rhetoric - Stanford | https://plato.stanford.edu/entries/aristotle-rhetoric/ |
| Modes of Persuasion - Wikipedia | https://en.wikipedia.org/wiki/Modes_of_persuasion |
| Monroe's Motivated Sequence - Lumen | https://courses.lumenlearning.com/wm-publicspeaking/chapter/monroes-motivated-sequence/ |
| AIDA Model - Wikipedia | https://en.wikipedia.org/wiki/AIDA_(marketing) |
| Ethical Edge of Persuasion - Psychology Today | https://www.psychologytoday.com/us/blog/leading-in-the-real-world/202102/the-ethical-edge-of-persuasion |
| Cialdini's 7 Principles - Influence at Work | https://www.influenceatwork.com/7-principles-of-persuasion/ |
| PAS Framework - SaaS Funnel Lab | https://www.saasfunnellab.com/essay/pas-copywriting-framework/ |

## File Structure

```
content/skills/communication/persuasion-framework-builder/
  index.md    -- Hugo page with frontmatter and skill_content (500+ lines)
  SKILL.md    -- Usage guide, framework overview, examples, customization tips
  INIT.md     -- This file (self-contained recreation manifest)
```

## Recreation Instructions

To recreate this skill:
1. Create directory at `content/skills/communication/persuasion-framework-builder/`
2. Generate `index.md` with Hugo frontmatter using the metadata, variables, and research sources above
3. Write the `skill_content` field as a comprehensive persuasion prompt covering all frameworks, principles, and response format detailed above (minimum 500 lines)
4. Generate `SKILL.md` as a user-facing guide with overview, step-by-step usage, example prompts, and customization tips
5. Generate `INIT.md` (this file) as a self-contained manifest
6. Create .zip package using `python scripts/create_skill_zip.py content/skills/communication/persuasion-framework-builder`
7. Add entry to `data/imported_skills.yaml`
