# Persuasion Framework Builder

## Overview

The Persuasion Framework Builder is an advanced AI skill that helps you construct compelling, ethical persuasive arguments for any communication need. Whether you are writing a sales email, delivering a board presentation, crafting a fundraising pitch, or preparing an internal proposal, this skill selects the optimal persuasion framework and builds a complete argument structure you can use immediately.

## What This Skill Does

When you provide your persuasion scenario, the skill:

1. **Analyzes your situation** -- audience profile, communication medium, and resistance points
2. **Selects the optimal framework** from a library of five proven persuasion models
3. **Applies Cialdini's principles** of influence strategically to your specific context
4. **Balances rhetorical appeals** (ethos, pathos, logos, kairos) based on your audience
5. **Prepares objection handling** with specific response scripts
6. **Crafts storytelling elements** when narrative would strengthen your case
7. **Builds a complete draft** ready to use or customize
8. **Verifies ethical boundaries** to ensure transparent, honest influence

## Frameworks Included

### Copywriting Frameworks
- **AIDA** (Attention - Interest - Desire - Action) -- Best for sales pages, ads, cold outreach
- **PAS** (Problem - Agitate - Solve) -- Best for sales emails, landing pages, change proposals
- **BAB** (Before - After - Bridge) -- Best for short-form content, transformation narratives
- **4Ps** (Promise - Picture - Proof - Push) -- Best for testimonial-driven campaigns, product launches

### Speech and Presentation Framework
- **Monroe's Motivated Sequence** (Attention - Need - Satisfaction - Visualization - Action) -- Best for speeches, board proposals, policy arguments, persuasive essays

### Psychological Influence Principles
- **Cialdini's 7 Principles**: Reciprocity, Commitment/Consistency, Social Proof, Authority, Liking, Scarcity, Unity

### Classical Rhetoric
- **Aristotle's Appeals**: Ethos (credibility), Pathos (emotion), Logos (logic), Kairos (timing)

## How to Use

### Step 1: Copy the Skill
Click the **Copy Skill** button on the skill page to copy the full prompt to your clipboard.

### Step 2: Open Your AI Assistant
Open Claude, ChatGPT, Gemini, Copilot, or any compatible AI assistant.

### Step 3: Paste and Provide Your Scenario
Paste the skill prompt, then describe your situation with these four inputs:

| Input | Description | Example |
|-------|-------------|---------|
| **Core Message** | What you want to persuade someone of | "Adopt a new testing framework for our team" |
| **Target Audience** | Who you are persuading | "VP of Engineering, risk-averse, data-driven" |
| **Medium** | How you will deliver the argument | "Email followed by a 15-minute meeting" |
| **Resistance Points** | Expected objections or skepticism | "Migration cost, learning curve, 'current tool works fine'" |

### Step 4: Receive Your Complete Persuasive Argument
The AI will deliver:
- A situation analysis with framework recommendation
- The full argument structured in the selected framework
- Rhetorical balance recommendations
- Cialdini principles applied to your specific case
- Objection handling table with scripted responses
- A call to action with primary and backup options
- A complete draft you can use or adapt
- An ethics verification check

## Example Prompts

### Internal Proposal
> "I need to convince my VP of Engineering to let my team adopt a new testing framework. They're skeptical because the current one 'works fine' and they're worried about migration costs. Help me build a persuasive case."

### Sales Outreach
> "I'm writing a cold email to CTOs of mid-size SaaS companies. I want them to book a demo of our monitoring tool. Their main objection is that they already use Datadog. Help me build a persuasive email."

### Fundraising Pitch
> "I'm preparing a 5-minute pitch for angel investors for my climate tech startup. They'll be skeptical about our ability to scale. We have pilot data from two municipalities. Build me a compelling pitch."

### Policy Argument
> "I need to persuade our city council to approve a bike lane network. Council members are worried about parking loss and business opposition. I'm presenting at next Tuesday's meeting."

### Marketing Copy
> "I'm writing a landing page for an online course about personal finance. Target audience is millennials who feel overwhelmed by money. Help me structure persuasive copy."

## Customization Tips

- **For technical audiences**: Request heavier emphasis on logos (data, evidence, logic) and reduced pathos
- **For executive audiences**: Ask for bottom-line framing with social proof and ROI data
- **For resistant audiences**: Request the ethos-first approach with inoculation against key objections
- **For short-form content**: Specify the medium (tweet, email, social post) to get appropriately concise output
- **For long-form presentations**: Request a Monroe's Motivated Sequence with full visualization scripts

## What Makes This Different

Most persuasion resources teach frameworks in isolation. This skill integrates all major frameworks and lets the AI select and combine them based on your specific situation. It also enforces ethical boundaries -- every argument passes a five-point ethics test to ensure you are persuading honestly, not manipulating.

## Related Skills

- **Active Listening Master** -- Understand your audience before persuading them
- **Conflict Resolution Expert** -- Navigate resistance when persuasion meets pushback
- **Negotiation Strategist** -- Negotiate outcomes after the persuasive groundwork
- **Logical Fallacy Detector** -- Ensure your arguments are logically sound
- **Devil's Advocate** -- Stress-test your arguments before delivery
