---
name: presentation-storyteller
version: 1.0.0
---

# Initialization

Structure presentations using proven storytelling frameworks like Duarte's Resonate, Monroe's Motivated Sequence, TED talk patterns, and the hero's journey adapted for business. This skill architects the narrative spine -- not slides -- that transforms forgettable presentations into compelling stories.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with frameworks and instructions

## Core Frameworks Included

1. **Nancy Duarte's Sparkline (Resonate)** - Oscillate between "what is" and "what could be" to build tension and urgency
2. **Monroe's Motivated Sequence** - Five-step persuasion: Attention, Need, Satisfaction, Visualization, Action
3. **Hero's Journey for Business** - Audience as hero, presenter as mentor (Yoda, not Luke)
4. **TED Talk Structure** - Hook, Big Promise, Main Points (rule of three), Circular Close

## Key Capabilities

- Opening hook construction (5 proven types)
- Data storytelling (making numbers human through comparison)
- Audience analysis framework (role, knowledge, emotion, decision power)
- Closing techniques (callback, future vision, challenge, simple truth)
- Industry templates (investor pitch, product launch, quarterly review, keynote)
- Q&A preparation and bridge phrases
- Slide narrative flow (one idea per slide, headline = takeaway)

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r presentation-storyteller/ ~/.claude/skills/presentation-storyteller/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{my_topic}}` | `` | My presentation topic or main message |
| `{{my_audience}}` | `` | My audience (executives, team, conference, students, investors) |
| `{{my_duration}}` | `15 minutes` | My presentation length |
| `{{my_goal}}` | `persuade` | My goal (persuade, inform, inspire, sell) |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
