---
name: 10x-your-prompts
version: 1.0.0
description: Systematic prompt iteration and optimization for dramatically better AI outputs
author: FindSkill.ai
license: MIT
---

# Initialization

This skill transforms you into a prompt iteration expert, teaching the systematic refinement process that turns mediocre prompts into high-performance AI instructions.

## Overview

**What this skill does:**
- Diagnoses why prompts produce poor outputs
- Teaches the RICECO framework for structuring prompts
- Guides systematic iteration (E-I-O process)
- Provides advanced techniques like anchoring and self-critique

**Time to initialize:** ~1 minute (prompt-only skill)

## Directory Structure

```
10x-your-prompts/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization file
```

## Dependencies

None - this is a prompt-only skill.

## Files to Generate

None - copy SKILL.md content directly to use.

## Post-Init Steps

### For Claude Code Users
```bash
# Copy to your skills directory
cp -r 10x-your-prompts/ ~/.claude/skills/
```

### For Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter
3. Paste into your AI assistant

## Compatibility

Tested with:
- Claude (Opus, Sonnet, Haiku)
- ChatGPT (GPT-4, GPT-4o)
- Gemini (Pro, Ultra)
- Copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{current_prompt}}` | [Your prompt] | Prompt to improve |
| `{{desired_outcome}}` | Clear output | What you want |
| `{{problem}}` | Too generic | What's wrong |

## Quick Start

After initialization, try:

1. **Improve a specific prompt:**
   "Here's my prompt: '[prompt]'. The outputs are [problem]. Help me iterate to get [desired result]."

2. **Learn the framework:**
   "Teach me the RICECO framework for prompt engineering with examples."

3. **Diagnose issues:**
   "Why are my AI outputs always too generic? What am I missing?"

4. **A/B test variations:**
   "Create 3 variations of this prompt and explain the differences: [prompt]"

## Key Frameworks

### RICECO Framework
- **R**ole - Who the AI should be
- **I**nstructions - Clear task definition
- **C**ontext - Background and constraints
- **E**xamples - What good looks like
- **C**onstraints - Boundaries and requirements
- **O**utput - Exact format specification

### E-I-O Process
1. **Evaluate** - What's wrong with current output?
2. **Iterate** - Change one variable at a time
3. **Optimize** - A/B test and refine

### Problem-Cause-Fix Matrix
| Symptom | Cause | Fix |
|---------|-------|-----|
| Generic | No context | Add specifics |
| Wrong tone | No role | Define persona |
| Too long | No limits | Add constraints |
| Off-topic | Vague task | Clear steps |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
