---
name: acquisition-target-scorer
version: 1.0.0
---

# Acquisition Target Scorer - Initialization

A comprehensive M&A acquisition evaluation skill that transforms subjective deal assessment into data-driven, investment committee-ready recommendations. Combines financial valuation (DCF, comps, precedents), strategic fit analysis, and cultural compatibility scoring with weighted frameworks.

## Structure

```
acquisition-target-scorer/
├── SKILL.md      # Main skill prompt (comprehensive M&A evaluation)
└── INIT.md       # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill. The SKILL.md contains the complete acquisition evaluation framework.

## Post-Init Steps

### Claude Code Installation

```bash
# Copy to Claude Code skills directory
cp -r acquisition-target-scorer/ ~/.claude/skills/acquisition-target-scorer/

# Verify installation
ls ~/.claude/skills/acquisition-target-scorer/
```

### Other AI Assistants

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or context

### Usage Examples

**Multi-Target Screening:**
```
Score these three fintech acquisition targets (TechPay, PayFlow, DigitalVault)
on strategic fit for our digital payments platform expansion. Each must satisfy
these must-haves: positive EBITDA, minimum 30% YoY revenue growth, market cap
<$500M, and experienced founding team with >5 years relevant experience.
```

**Valuation Analysis:**
```
Build a detailed acquisition valuation for CloudSync, a SaaS CRM platform:
FY2023 Revenue $12M (35% YoY growth), Normalized EBITDA $3M (25% margin),
Net Debt $500K. Apply DCF, trading comps, and precedent transaction analysis
with a 20% IRR target for a 5-year exit.
```

**Cultural Assessment:**
```
Evaluate cultural compatibility for acquisition of InnovateLabs (fast-paced
startup, 50 employees, flat hierarchy, 40% remote work) into our traditional
manufacturing parent. Score across decision-making, work environment,
compensation, and values dimensions. Identify integration risks and mitigation.
```

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{investment_horizon_years}}` | `5` | Number of years for valuation projections and synergy timeline |
| `{{required_roi_hurdle_rate}}` | `20%` | Minimum acceptable IRR threshold for deal approval |
| `{{synergy_confidence_level}}` | `0.60` | Probability adjustment for synergy realization (cost: 0.80, revenue: 0.45) |
| `{{cultural_fit_weight}}` | `0.35` | Importance multiplier for cultural alignment in composite score |
| `{{integration_cost_percentage}}` | `5%` | One-time integration costs as percentage of purchase price |
| `{{valuation_multiple_range_spread}}` | `0.20` | Confidence interval (±20%) around fair value multiples |

## Core Capabilities

1. **Initial Target Screening** - Filter candidates against must-have criteria (profitability, growth, compliance) with binary pass/fail gates
2. **Six-Dimension Scoring** - Evaluate targets across Investment Thesis, Strategic Fit, Financial Performance, Cultural Alignment, Operational Stability, and Implementation Feasibility
3. **Valuation Triangulation** - Apply DCF, comparable company multiples, and precedent transactions for defensible pricing ranges
4. **Synergy Quantification** - Model cost synergies (80% confidence) and revenue synergies (45% confidence) with realization timelines
5. **Cultural Risk Assessment** - Analyze decision-making styles, work environment compatibility, and create 90-day integration plans
6. **Go/No-Go Framework** - Synthesize analyses into investment committee presentations with clear recommendations

## Evaluation Framework

**Dimension Weights:**
- Investment Thesis: 15%
- Strategic Fit: 25%
- Financial Performance: 25%
- Cultural Alignment: 15%
- Operational Stability: 10%
- Implementation Feasibility: 10%

**Scoring Scale:**
- 9-10: Exceptional
- 7-8: Strong
- 5-6: Adequate
- 3-4: Weak
- 1-2: Disqualifying

**Decision Thresholds:**
- Proceed: Composite >= 7.0, no critical red flags
- Conditional: 6.0-7.0 or specific issues to resolve
- Pass: < 6.0 or critical must-have failures

## Key Terminology

- **EBITDA**: Earnings Before Interest, Taxes, Depreciation, Amortization
- **Normalized EBITDA**: Adjusted for one-time/non-recurring items
- **DCF**: Discounted Cash Flow intrinsic valuation
- **Trading Comps**: Comparable company multiple analysis
- **Precedents**: Prior M&A transaction multiples
- **EV/EBITDA**: Enterprise Value / EBITDA valuation ratio
- **PMI**: Post-Merger Integration
- **NWC**: Net Working Capital adjustment
- **QoE**: Quality of Earnings analysis

## Research Sources

- M&A Target Scorecard Template (bymichaelhofer.com)
- Strategic Fit in SMB Acquisitions (withkumo.com)
- DCF vs Multiples vs Precedents (auxocapitaladvisors.com)
- M&A Integration Playbook (ceinterim.com)
- M&A Due Diligence Guide (diligent.com)

---
Downloaded from [Find Skill.ai](https://findskill.ai)
