---
name: agentic-task-decomposer
version: 1.0.0
---

# Initialization

Break down complex tasks into agent-friendly subtasks that AI agents can execute autonomously. Structure requests for better AI agent performance with ReAct patterns and proven agentic frameworks.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with task decomposition framework
- `index.md` - Hugo page with frontmatter and extended documentation

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r agentic-task-decomposer/ ~/.claude/skills/agentic-task-decomposer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{complex_task}}` | `[Describe your complex task here]` | The complex task I want to break down |
| `{{available_tools}}` | `web search, file read/write, code execution` | Tools and capabilities my AI agent has access to |
| `{{autonomy_level}}` | `human-in-loop checkpoints` | How autonomous should the agent be |
| `{{time_constraint}}` | `no specific deadline` | Time available for task completion |
| `{{error_tolerance}}` | `retry once, then escalate` | How to handle failures |

## Core Concepts

### Agentic Patterns Supported

1. **ReAct (Reasoning + Acting)**: For dynamic, exploratory tasks
2. **Plan-and-Execute**: For well-defined, structured workflows
3. **Hierarchical Task Network (HTN)**: For complex, multi-milestone projects

### Decomposition Rules

- **Atomic Actions**: Single, verifiable operations
- **Clear Success Criteria**: Measurable completion states
- **Explicit Dependencies**: What must be true before starting
- **Tool Specification**: Exact capability needed per step
- **Error Handling**: Defined failure responses

### Autonomy Levels

- **Level 1**: Fully autonomous (low-risk, deterministic)
- **Level 2**: Checkpointed (human review at milestones)
- **Level 3**: Supervised (approval per action)

## Example Usage

```
User: "I need to research competitor pricing, create a comparison spreadsheet,
       generate a summary report, and email it to my team."

Skill Output:
- Phase 1: Research (4 subtasks)
- Phase 2: Data Processing (3 subtasks)
- Phase 3: Report Generation (2 subtasks)
- Phase 4: Distribution (2 subtasks)
- With full dependency graph, error handling, and agent prompts
```

## Research Sources

- ReAct: Synergizing Reasoning and Acting in Language Models (arXiv)
- Building Effective AI Agents (Anthropic Research)
- A Practical Guide to Building Agents (OpenAI)
- TDAG: Multi-Agent Framework for Dynamic Task Decomposition

---
Downloaded from [Find Skill.ai](https://findskill.ai)
