---
name: ai-proof-your-career
version: 1.0.0
description: Career strategy for the AI era - build hybrid skills that command a 56% wage premium
author: FindSkill.ai
license: MIT
---

# Initialization

This skill helps you create a personalized career strategy that makes you irreplaceable in the AI era by combining uniquely human capabilities with AI fluency.

## Overview

**What this skill does:**
- Assesses your AI vulnerability and opportunity
- Identifies your "human superpowers" to develop
- Creates a 90-day AI upskilling roadmap
- Positions you as an AI-augmented professional

**Time to initialize:** ~1 minute (prompt-only skill)

## Directory Structure

```
ai-proof-your-career/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization file
```

## Dependencies

None - this is a prompt-only skill.

## Files to Generate

None - copy SKILL.md content directly to use.

## Post-Init Steps

### For Claude Code Users
```bash
# Copy to your skills directory
cp -r ai-proof-your-career/ ~/.claude/skills/
```

### For Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter
3. Paste into your AI assistant

## Compatibility

Tested with:
- Claude (Opus, Sonnet, Haiku)
- ChatGPT (GPT-4, GPT-4o)
- Gemini (Pro, Ultra)
- Copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{current_role}}` | Marketing Manager | Your job title |
| `{{experience_years}}` | 5 | Years of experience |
| `{{career_goals}}` | Senior leadership | 3-5 year goal |
| `{{ai_comfort}}` | basic | AI skill level |

## Quick Start

After initialization, try:

1. **Full career assessment:**
   "I'm a [role] with [X] years experience. I'm worried about AI impact. Create my AI-proof career strategy."

2. **Skill gap analysis:**
   "What AI skills should a [role] in [industry] develop to stay competitive?"

3. **90-day roadmap:**
   "Create a 90-day AI upskilling plan for someone in [role] who wants to reach [goal]."

4. **Positioning help:**
   "Help me write a LinkedIn summary that positions me as an AI-augmented [role]."

## Key Frameworks

### SHIELD Framework
- **S**kills Audit - Assess tasks vs AI risk
- **H**uman Superpowers - EQ, creativity, ethics, leadership
- **I**ndustry Position - Know your field's AI exposure
- **E**xpertise Building - AI fluency stack (3 levels)
- **L**earning Roadmap - 90-day plan
- **D**ifferentiation - Hybrid professional formula

### The Hybrid Formula
```
Human Skill + AI Fluency + Domain Expertise = Irreplaceable
```

### Key Statistics
- 56% wage premium for AI-skilled workers
- 67% hiring managers prefer AI skills
- 40% productivity gains with AI
- 78M net new jobs from AI by 2030

---
Downloaded from [Find Skill.ai](https://findskill.ai)
