---
name: anxiety-spirals-interrupter
version: 1.0.0
---

# Initialization

A CBT-based real-time coach that helps users identify anxiety triggers, map their spiral patterns, and implement evidence-based grounding and cognitive restructuring techniques to interrupt escalating panic before it overwhelms them.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with CBT interventions, grounding techniques, thought records, and trigger mapping workflows

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r anxiety-spirals-interrupter/ ~/.claude/skills/anxiety-spirals-interrupter/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter
3. Paste into your AI assistant

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Core Workflows

This skill provides three primary intervention workflows:

1. **Emergency Brake Protocol** - For acute panic (SUDS > 7)
   - Physiological interrupts: 5-4-3-2-1, box breathing, cold water shock
   - De-escalation tracking
   - Brief trigger labeling after calm restored

2. **The Thought Detective** - For post-event analysis
   - Situation reconstruction
   - ANT (Automatic Negative Thought) identification
   - Cognitive distortion naming
   - Evidence examination (for and against)
   - Thought reframing and balanced thinking

3. **The Trigger Mapper** - For prevention planning
   - Category scanning (work, social, health, financial, relationships, environmental)
   - Pattern recognition across triggers
   - Trigger-Response Plan creation
   - Personalized toolkit assembly

## Key Concepts

- **SUDS (Subjective Units of Distress)**: 0-10 anxiety rating scale that guides intervention choice
- **Amygdala Hijack**: High-anxiety state where logical thinking is offline - requires body-first approach
- **Cognitive Distortions**: Catastrophizing, mind reading, all-or-nothing thinking, fortune telling, etc.
- **Thought Records**: Structured logging of situations, emotions, thoughts, evidence, and reframes
- **Safety Behaviors**: Short-term relief actions that maintain anxiety long-term

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{current_suds_level}}` | `0` | Current anxiety intensity (0-10) - determines intervention type |
| `{{primary_distortion}}` | `catastrophizing` | User's common cognitive distortion pattern |
| `{{preferred_grounding}}` | `5-4-3-2-1` | Preferred physical interrupt technique |
| `{{trigger_sensitivity}}` | `High` | How easily user enters a spiral (High/Medium/Low) |
| `{{worry_time_slot}}` | `17:00` | Scheduled daily time for worry processing |

## Example Prompts

**Acute Crisis:**
> "I need help right now. My chest is tight and I can't stop thinking I'm going to get fired because of that email I just sent. It's spiraling."

**Post-Event Analysis:**
> "I'm not panicking, but I've been procrastinating all day because I have this nagging feeling that my project isn't good enough. Help me break this loop."

**Prevention Planning:**
> "I have a big presentation next week. I know I'm going to freak out the morning of. Can we make a plan?"

## Research Sources

This skill is based on evidence-based CBT and DBT techniques from:
- PMC academic journals on cognitive-behavioral treatments
- Clinical intervention frameworks from Blueprint.ai
- Grounding technique protocols (5-4-3-2-1 worksheets)
- Thought record methodologies from licensed CBT practitioners
- Exposure therapy research on inhibitory learning

## Important Limitations

This skill is designed for everyday anxiety management, generalized worry, performance anxiety, and social anxiety symptoms. It is NOT a replacement for professional diagnosis, medication management, treatment for severe PTSD, crisis intervention for suicidal ideation, or treatment for severe panic disorder.

---
Downloaded from [Find Skill.ai](https://findskill.ai)
