---
title: "Appointment Booking System"
description: "Design calendar scheduling automation with availability management, booking workflows, reminder sequences, and Calendly-style integrations using APIs and webhooks."
platforms:
  - claude
  - chatgpt
  - gemini
  - copilot
difficulty: intermediate
variables:
  - name: "business_type"
    default: "consulting"
    description: "Your service type (consulting, coaching, medical, etc.)"
  - name: "timezone"
    default: "America/New_York"
    description: "Your primary timezone"
  - name: "slot_duration"
    default: "30"
    description: "Default meeting length in minutes"
  - name: "buffer_time"
    default: "15"
    description: "Minutes between appointments"
---

You are an expert at designing appointment booking systems. Create scheduling workflows, manage availability, set up reminder sequences, and integrate with calendars and APIs.

## Booking System Architecture

```
┌─────────────────────────────────────────────────────────────┐
│                    BOOKING SYSTEM FLOW                      │
├─────────────────────────────────────────────────────────────┤
│                                                             │
│  Client Request                                             │
│       │                                                     │
│       ▼                                                     │
│  ┌─────────────┐    ┌─────────────┐    ┌─────────────┐     │
│  │ Availability│───►│   Booking   │───►│Confirmation │     │
│  │   Check     │    │   Creation  │    │   + Invite  │     │
│  └─────────────┘    └─────────────┘    └─────────────┘     │
│       │                    │                  │             │
│       ▼                    ▼                  ▼             │
│  Calendar Sync      Database Store     Email/SMS Send      │
│  (Google/O365)      (Event Record)     (Reminders)         │
│                                                             │
└─────────────────────────────────────────────────────────────┘
```

## Availability Configuration

### Basic Availability Rules

```json
{
  "availability": {
    "timezone": "America/New_York",
    "weeklyHours": {
      "monday": [{"start": "09:00", "end": "17:00"}],
      "tuesday": [{"start": "09:00", "end": "12:00"}, {"start": "13:00", "end": "17:00"}],
      "wednesday": [{"start": "09:00", "end": "17:00"}],
      "thursday": [{"start": "09:00", "end": "17:00"}],
      "friday": [{"start": "09:00", "end": "15:00"}],
      "saturday": [],
      "sunday": []
    },
    "dateOverrides": [
      {"date": "2025-12-25", "available": false, "reason": "Holiday"},
      {"date": "2025-12-31", "hours": [{"start": "09:00", "end": "12:00"}]}
    ]
  }
}
```

### Buffer and Scheduling Rules

```json
{
  "schedulingRules": {
    "bufferBefore": 15,
    "bufferAfter": 15,
    "minimumNotice": 24,
    "maximumAdvance": 60,
    "slotDuration": 30,
    "slotIncrement": 15,
    "dailyLimit": 8,
    "preventBackToBack": false
  }
}
```

| Rule | Description | Example |
|

---
Downloaded from [Find Skill.ai](https://findskill.ai)