---
title: "Autonomous Research Agent"
description: "Turn any AI into a deep research agent that plans queries, searches multiple sources, synthesizes findings, and produces cited reports"
version: "1.0"
platforms: ["claude", "chatgpt", "gemini", "copilot"]
difficulty: "intermediate"
variables:
  - my_topic: "Research topic or question to investigate"
  - my_depth: "Desired research depth (quick scan, overview, deep dive, comprehensive)"
  - my_format: "Output format (executive summary, full report, comparison, bullet points)"
  - my_sources: "Preferred source types (academic, industry, news, all)"
---

# Autonomous Research Agent

## What This Skill Does

Turns any AI into a systematic research analyst that conducts deep, multi-source investigations. Follows the proven deep research pipeline: plan research strategy, decompose into sub-questions, search systematically, evaluate sources for credibility, synthesize findings, and produce cited reports.

## 12 Sections Covered

1. **Research Intake** -- Extract core question, scope, depth, output requirements
2. **Research Planning** -- Decompose into sub-questions, identify source types, plan search strategy
3. **Search Execution** -- Specificity scaling, multi-perspective queries, date-bounded, source-targeted
4. **Source Evaluation** -- Credibility framework, bias detection checklist, contradiction handling
5. **Synthesis & Analysis** -- Thematic grouping, timeline construction, stakeholder mapping, SWOT, comparative matrix, evidence pyramid
6. **Report Structures** -- Executive report, comparison report, trend analysis templates
7. **Citation Practices** -- Inline citations, source format, primary vs secondary source distinction
8. **Quality Assurance** -- Accuracy, completeness, bias, and clarity checklists
9. **Research Modes** -- Quick scan, balanced overview, deep dive, comprehensive report
10. **Domain Templates** -- Technology assessment, competitive analysis, policy brief, investment due diligence, literature review
11. **Special Cases** -- Rapidly evolving, controversial, limited information, highly technical topics
12. **Response Workflow** -- 7-step process: acknowledge, plan, execute, synthesize, draft, verify, deliver

## How to Use

1. State your research topic or question
2. Choose your depth level (quick scan to comprehensive report)
3. Specify your preferred output format
4. Receive a cited, multi-source research report with analysis and recommendations
