---
name: bill-negotiation-scripts
version: 1.0.0
description: Create proven negotiation scripts for lowering bills
author: FindSkill.ai
license: MIT
---

# Initialization

Create personalized negotiation scripts for lowering cable, internet, medical bills, insurance rates, and subscription costs.

## Overview

This is a prompt-only skill with no scripts to generate. The skill provides:
- Word-for-word negotiation scripts
- Company-specific tactics
- Objection handling responses
- Best practices for timing and preparation

**Time to initialize**: Immediate (no setup required)

## Directory Structure

```
bill-negotiation-scripts/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This file
```

## Dependencies

None required.

## Files to Generate

None (prompt-only skill).

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r bill-negotiation-scripts/ ~/.claude/skills/bill-negotiation-scripts/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

Customize these in your requests:

| Variable | Default | Description |
|----------|---------|-------------|
| `bill_type` | `internet` | Type of bill (cable, internet, medical, insurance, subscription) |
| `company_name` | `` | Company you're negotiating with |
| `current_monthly_cost` | `` | Current monthly payment |
| `years_as_customer` | `` | How long you've been a customer |
| `competitor_offer` | `` | Lower price from a competitor |

## Example Usage

```
I need to negotiate my Comcast internet bill. I've been a customer for 5 years,
currently paying $89/month. Xfinity is offering new customers $49/month for
similar speeds. Create a negotiation script for calling their retention department.
```

## Key Features

### Supported Bill Types
- Cable TV and internet
- Cell phone and landline
- Medical bills and hospital charges
- Car, home, and renters insurance
- Gym memberships and subscriptions
- Bank fees and credit card rates

### Script Components
- Opening statements that establish loyalty
- Competitive leverage language
- Escalation phrases for when initial request fails
- Objection handling for common pushback
- Closing confirmation checklist

### Success Rate Data
- Cable/Internet: 92% get some reduction
- Medical Bills: 40% get reductions
- Insurance: 10-30% through discounts
- Subscriptions: 50-70% retention success

---
Downloaded from [Find Skill.ai](https://findskill.ai)
