---
name: board-meeting-minutes
version: 1.0.0
description: Create formal corporate board meeting minutes with legal compliance format
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

Prompt-only skill for creating legally compliant board meeting minutes. No scripts required.

**What it does:**
- Formats minutes per corporate governance standards
- Includes proper resolution language
- Documents motions and voting
- Handles conflicts of interest
- Supports written consent in lieu of meeting

**Time to initialize:** Instant

## Directory Structure

```
board-meeting-minutes/
├── SKILL.md
└── INIT.md
```

## Dependencies

None

## Post-Init Steps

### Claude Code Users
```bash
cp -r board-meeting-minutes/ ~/.claude/skills/board-meeting-minutes/
```

### Other AI Assistants
Copy SKILL.md content into your AI assistant.

## Usage Examples

### Regular Board Meeting
```
Create board minutes for TechCorp Inc (Delaware):

Date: January 15, 2025, 2:00 PM EST (Virtual)
Directors present: Sarah Chen (Chair), Michael Torres,
  Dr. Priya Sharma, James Wilson
Absent: None

Actions:
1. Approved Q4 financials
2. Authorized $2M bridge financing
3. Appointed Lisa Park as interim CEO
All passed unanimously.
```

### Written Consent
```
Create a written consent in lieu of meeting:

Corporation: StartupCo Inc (Delaware)
Directors: John Smith, Jane Doe, Bob Wilson

Resolution: Authorize Series A financing of $5M
from Venture Capital Partners.
```

## Disclaimer

This skill provides templates and formatting assistance. Always have corporate minutes reviewed by qualified legal counsel before finalizing.

---
Downloaded from [FindSkill.ai](https://findskill.ai)
