---
name: board-meeting-minutes
description: Create formal corporate board meeting minutes with legal compliance format including motions, resolutions, and votes. Use for any board meeting requiring formal documentation.
platforms:
  - claude
  - chatgpt
  - gemini
  - copilot
difficulty: advanced
variables:
  - name: "company_name"
    default: "Acme Corporation"
    description: "Corporation's full legal name"
  - name: "jurisdiction"
    default: "Delaware, USA"
    description: "State/country of incorporation"
  - name: "meeting_type"
    default: "Regular"
    description: "Regular, Special, or Annual"
---

# Board Meeting Minutes

Create legally compliant board meeting minutes for corporate governance.

## Quick Start

1. Provide meeting details (date, time, location)
2. List directors present/absent
3. Describe actions taken and votes
4. Get formal minutes ready for signature

## Why Minutes Matter

- First documents plaintiffs' lawyers request
- Evidence of fiduciary duty compliance
- Protect corporate veil and limited liability
- Required by state law for most corporations
- Must be retained 10+ years

## Standard Format

```
MINUTES OF [TYPE] MEETING
OF THE BOARD OF DIRECTORS
OF [CORPORATION NAME]

DIRECTORS PRESENT: [Names]
DIRECTORS ABSENT: [Names]
QUORUM: Confirmed

RESOLVED, that [specific action] is hereby
approved.

The resolution was duly moved, seconded,
and unanimously adopted.

Respectfully submitted,
[Secretary Name]
```

## Critical Rules

**DO Include:**
- All directors (present/absent)
- Quorum confirmation
- Clear resolutions
- Voting results

**DO NOT Include:**
- Comments attributed to specific directors
- Detailed discussion summaries
- Emotional language
- Inconsistent voting descriptors

---
Downloaded from [FindSkill.ai](https://findskill.ai)
