---
name: book-club-reading-planner
version: 1.0.0
---

# Initialization

Book Club & Reading Plan Designer - Create goal-aligned reading lists, facilitate engaging book discussions, and implement spaced repetition retention strategies for individuals and groups.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive instructions for book selection, discussion facilitation, and retention planning

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r book-club-reading-planner/ ~/.claude/skills/book-club-reading-planner/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter
3. Paste into your AI assistant

## Compatibility

Tested with: Claude, ChatGPT, Gemini, Copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{learning_goal}}` | `Professional Development` | Primary learning objective driving book selection |
| `{{reading_pace}}` | `moderate` | User's reading speed (light, moderate, avid, intensive) |
| `{{discussion_depth}}` | `intermediate` | Complexity level of discussion questions |
| `{{group_size}}` | `6` | Number of participants in book club |
| `{{retention_focus}}` | `moderate` | Intensity of spaced repetition activities |
| `{{reading_duration}}` | `12 weeks` | Total weeks allocated for reading curriculum |

## Key Capabilities

1. **Intelligent Book Selection** - Curate goal-aligned reading lists with tiered recommendations
2. **Discussion Framework Design** - Generate multi-level questions using Bloom's Taxonomy and Socratic methods
3. **Spaced Repetition Planning** - Design evidence-based retention schedules using Pimsleur intervals
4. **Reading Schedule Creation** - Build realistic timelines with progress checkpoints
5. **Facilitation Coaching** - Techniques for inclusive, psychologically safe discussions

## Research Sources

This skill incorporates research from:
- ATD (Association for Talent Development) - Discussion facilitation best practices
- Maestro Learning - Pimsleur spaced repetition intervals
- Vanderbilt University - Literary Analysis Wheel for multi-level questioning
- NIH/PubMed - Literature circles and book club implementation studies
- Fountas & Pinnell - Book club discussion strategies

---
Downloaded from [Find Skill.ai](https://findskill.ai)
