---
name: breaking-point-recovery-plan
version: 1.0.0
---

# Breaking Point Recovery Plan

A comprehensive burnout recovery framework combining validated MBI assessment, phased 90-day recovery roadmaps, ACT/CBT psychological techniques, and organizational system recommendations for overwhelmed professionals.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with complete burnout recovery instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r breaking-point-recovery-plan/ ~/.claude/skills/breaking-point-recovery-plan/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (starting from "You are a Burnout Recovery Specialist...")
3. Paste into your AI assistant

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{burnout_severity}}` | `moderate` | Classification from assessment (low/moderate/high) |
| `{{recovery_timeline}}` | `90_days` | Program duration: 30_days, 60_days, 90_days, 180_days |
| `{{primary_stressor}}` | `workload` | Root cause: workload, control, values_mismatch, recognition, recovery_deficit, relationships |
| `{{support_structure}}` | `self_directed` | Implementation level: self_directed, coaching, crisis_stabilization |
| `{{organizational_change_capacity}}` | `individual_only` | System reform scope: individual_only, departmental, enterprise |
| `{{learning_preference}}` | `mixed` | Technique delivery: visual, kinesthetic, reflective, social, mixed |
| `{{digital_comfort_level}}` | `high` | Tech integration preference: low, medium, high |

## Key Capabilities

1. **Burnout Assessment** - Uses Maslach Burnout Inventory (MBI) framework to measure emotional exhaustion, depersonalization, and personal achievement
2. **Multi-Phase Recovery Roadmap** - Generates 7-stage progression from crisis stabilization through reintegration (1-week to 90-day timeframe)
3. **Evidence-Based Interventions** - ACT, CBT, mindfulness, journaling, boundary-setting matched to burnout profile
4. **Daily Anchored Routines** - Soft-structured schedules with morning/midday/evening touchpoints for low-energy implementation
5. **Organizational Recommendations** - Workload transparency, recognition redesign, recovery infrastructure, technology governance
6. **Boundary Conversation Scripts** - DEAR MAN framework scripts for manager and team conversations
7. **Relapse Prevention** - Early warning sign checklists, trigger-response protocols, quarterly renewal rituals

## Example Usage

```
I'm a 38-year-old engineering manager at a tech company. I feel constantly
exhausted, cynical about my team's potential, and I'm questioning whether
I'm actually good at my job. I'm working 55+ hours/week and skipped my
vacation last year. I have supportive friends and a therapist, but I feel
like my job itself is the problem. Can you assess my burnout severity and
generate a personalized 90-day recovery plan that includes conversations
I need to have with my boss about workload?
```

## Research Sources

- Maslach Burnout Inventory (MBI) - Gold standard 22-item burnout assessment
- Acceptance & Commitment Therapy (ACT) - Psychological flexibility for burnout
- Cognitive Behavioral Therapy (CBT) - Thought pattern reframing
- Job Demands-Resources (JD-R) Model - Organizational burnout framework
- Crisis Intervention Team (CIT) protocols - Crisis response standards

## Crisis Resources

**Important**: If experiencing suicidal thoughts or severe depression:
- **988 Suicide & Crisis Lifeline** (US): Call or text 988
- **Crisis Text Line**: Text HOME to 741741
- **Emergency Services**: 911 (US) or local emergency number

---
Downloaded from [Find Skill.ai](https://findskill.ai)
