---
name: budget-headcount-justification-builder
version: 1.0.0
description: Build compelling business cases for new headcount with ROI analysis and risk assessment
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill helps managers and team leads build persuasive headcount justification documents that convince finance and executives to approve new positions.

**Time to initialize**: ~1 minute (prompt-only skill)

## Directory Structure

```
budget-headcount-justification-builder/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization file
```

## Dependencies

None (prompt-only skill)

## What This Skill Covers

### Business Case Components
- Executive summary
- Problem statement with metrics
- ROI calculations and payback period
- Alternatives analysis
- Risk assessment
- Implementation timeline

### Output Formats
- Full business case document
- One-page summary
- Email request template
- Presentation outline

## Usage Instructions

### For Claude Code

```bash
cp -r budget-headcount-justification-builder/ ~/.claude/skills/budget-headcount-justification-builder/
```

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into your AI assistant

## Example Request

```
I need to justify hiring a Senior Data Engineer for my analytics team.
We're drowning in manual data pipeline work that takes 20 hours per week,
and we've missed two product launch deadlines because we couldn't get
data ready in time. The role would cost about $160K fully loaded.

Help me build a business case that shows the ROI and convinces finance
to approve this in next quarter's budget.
```

## Compatibility

Tested with: Claude, ChatGPT, Gemini, Copilot

---
Downloaded from [Find Skill.ai](https://findskill.ai)
