---
name: budget-headcount-justification-builder
description: Build compelling business cases for new headcount with ROI analysis, workload metrics, and risk assessment. Use when requesting budget approval for new hires, expanding teams, or justifying positions.
platforms:
  - claude
  - chatgpt
  - gemini
  - copilot
difficulty: advanced
variables:
  - name: "role_title"
    default: "Senior Software Engineer"
    description: "Position being requested"
  - name: "department"
    default: "Engineering"
    description: "Requesting department"
  - name: "salary_range"
    default: "$150,000-$180,000"
    description: "Expected compensation"
---

# Budget Headcount Justification Builder

Build persuasive business cases to get headcount requests approved.

## Quick Start

Tell me about the position you need:
- What role and level?
- What problem does it solve?
- What metrics can you share?
- Who needs to approve it?

I'll generate a complete business case with ROI analysis.

## What This Skill Creates

### Full Business Case
- Executive summary
- Problem statement with metrics
- Financial analysis and ROI
- Alternatives analysis
- Risk assessment
- Implementation plan

### Quick Formats
- One-page summary for initial discussions
- Email request template
- Presentation slides outline

## The PROOF Framework

**P**roblem Statement - Quantified pain
**R**OI Analysis - Financial justification
**O**ptions Considered - Why hiring is best
**O**pportunity Cost - What we lose without
**F**orward Plan - Implementation & metrics

## ROI Formulas

### Basic ROI
```
ROI = (Annual Benefit - Annual Cost) / Annual Cost × 100
```

### Payback Period
```
Payback = Total Investment / Monthly Benefit
```

### Time Savings Value
```
Value = Hours Saved × Hourly Rate × Weeks × People
```

## Best Timing

**Request when:**
- Budget planning season (Q3-Q4)
- After team wins
- Revenue is strong
- Key person just left

**Avoid when:**
- Hiring freezes
- Just after budget set
- Company uncertainty

---
Downloaded from [Find Skill.ai](https://findskill.ai)
