---
name: budget-personality-matcher
version: 1.0.0
---

# Initialization

Budget Personality Matcher combines behavioral finance, personality psychology, and habit formation science to identify the optimal budgeting methodology for individual users. Instead of generic budgeting advice, it assesses psychological characteristics to match users with methods that align with their natural tendencies.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with personality assessment framework, method matching logic, and habit formation guidance

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r budget-personality-matcher/ ~/.claude/skills/budget-personality-matcher/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (everything below the second `---`)
3. Paste into your AI assistant as a system prompt or conversation starter

## Compatibility

Tested with: Claude, ChatGPT, Gemini, Copilot

## Core Capabilities

1. **Personality-Based Method Matching** - Assess Big Five traits, HEXACO factors, and money personality archetypes to match optimal budgeting approach
2. **Behavioral Risk Profiling** - Identify spending triggers, impulse patterns, and financial anxiety indicators
3. **Habit Formation Roadmap** - Create 30-90 day implementation plans with cue-reward sequences
4. **Failure Diagnosis** - Analyze why past budget attempts failed based on personality-method mismatch
5. **Progress Tracking Customization** - Design accountability mechanisms matching motivation drivers

## Supported Budgeting Methods

| Method | Best Personality Fit |
|--------|---------------------|
| Zero-Based | High conscientiousness, detail lovers |
| 50/30/20 | Moderate personality, beginners |
| Envelope System | Impulsive spenders, visual learners |
| Pay Yourself First | Avoiders, low conscientiousness |
| Values-Based | Creative, purpose-driven |

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{assessment_depth}}` | `comprehensive` | Level of assessment (quick/comprehensive/deep) |
| `{{motivation_driver}}` | `intrinsic_primary` | Primary motivation type |
| `{{context_stability}}` | `moderate` | Environmental stability level |
| `{{implementation_pace}}` | `steady` | Habit formation speed (gradual/steady/accelerated) |
| `{{tracking_friction}}` | `moderate` | Tolerance for detailed tracking |
| `{{rebalance_frequency}}` | `quarterly` | Personality-method fit reassessment schedule |

## Example Usage

```
User: "I've tried budgeting several times but always fail within a few weeks.
I'm creative and hate detailed spreadsheets, but I also get anxious about money.
What budgeting method would actually work for someone like me?"

AI Response: Conducts personality assessment, identifies Creative + High Anxiety
profile, recommends 50/30/20 with Pay Yourself First automation, provides
60-day habit formation plan with low-friction tracking.
```

## Research Foundation

This skill is based on:
- Big Five and HEXACO personality psychology frameworks
- Lincoln & Swansea Universities research on personality-financial behavior correlations
- Oxford Review of Psychology research on habit formation and automaticity
- Meta-analysis of 41 studies on behavior change interventions (JMIR 2024)
- Behavioral finance research on spending triggers and financial anxiety

---
Downloaded from [Find Skill.ai](https://findskill.ai)
