---
name: business-continuity-plan-generator
version: 1.0.0
---

# Business Continuity Plan Generator - Initialization

An advanced AI skill for creating comprehensive business continuity plans with Business Impact Analysis (BIA), RTO/RPO targets, crisis communication protocols, incident command structures, and ISO 22301-aligned documentation for organizational resilience.

## Package Contents

```
business-continuity-plan-generator/
├── SKILL.md    # Main skill prompt (copy to AI assistant)
├── INIT.md     # This initialization file
└── index.md    # Hugo page file (for website only)
```

## Structure

- `SKILL.md` - Complete business continuity planning skill prompt with:
  - 7 core competencies (BIA, risk assessment, recovery strategy, crisis comms, incident response, testing, improvement)
  - 15 key terminology definitions (RTO, RPO, MTPD, BIA, CBF, SPOF, DRP, BCMS, failover, standby sites, etc.)
  - 6 detailed workflows (BIA, risk assessment, recovery strategy, crisis communication, incident command, testing)
  - Impact assessment matrix templates
  - Threat catalog and risk scoring frameworks
  - Technical and operational recovery strategies
  - Crisis communication message templates
  - Incident command hierarchy and activation criteria
  - Testing calendar and exercise templates
  - ISO 22301 compliance mapping
  - Troubleshooting guide for common challenges

## Files to Generate

None required - this is a prompt-only skill. All functionality is contained in `SKILL.md`.

## Installation

### Claude Code / Claude Desktop

```bash
# Copy skill to Claude Code skills directory
cp -r business-continuity-plan-generator/ ~/.claude/skills/business-continuity-plan-generator/
```

Then reference in conversations:
```
Use the business-continuity-plan-generator skill to help me create a BCP for my organization.
```

### ChatGPT / GPT-4

1. Open `SKILL.md`
2. Copy all content after the `---` frontmatter block
3. Paste as a Custom Instruction or at the start of a new conversation

### Gemini

1. Open `SKILL.md`
2. Copy the full prompt content
3. Paste at conversation start or use in Google AI Studio

### Copilot

1. Open `SKILL.md`
2. Copy the prompt content
3. Paste in Copilot chat

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{organization_type}}` | `Enterprise` | Organization classification (Enterprise, Mid-Market, SME, Healthcare, Finance, Critical Infrastructure) |
| `{{max_acceptable_rto_hours}}` | `4` | Maximum Recovery Time Objective in hours - drives infrastructure decisions |
| `{{max_acceptable_rpo_hours}}` | `1` | Maximum Recovery Point Objective in hours - determines backup frequency |
| `{{critical_function_count}}` | `7` | Number of critical business functions requiring detailed recovery procedures |
| `{{testing_frequency_per_year}}` | `2` | Number of major BCP exercises conducted annually |
| `{{recovery_site_type}}` | `Warm Standby` | Alternate facility type (Cold Standby, Warm Standby, Hot Standby) |

## Example Usage

```
Create a Business Continuity Plan for our 200-person e-commerce company.
Critical functions are:
- Order processing (max 2 hours downtime)
- Payment systems (max 30 minutes)
- Customer support (max 4 hours)
- Inventory management (max 8 hours)

We're concerned about cyberattacks, cloud provider outages, and supply chain disruptions.
Include recovery strategies, communication templates, and a testing schedule.
```

## Key Capabilities

1. **Business Impact Analysis (BIA)**
   - Function inventory templates
   - Impact assessment matrices
   - Dependency mapping
   - Recovery prioritization (Tier 1-4)

2. **Risk Assessment**
   - Threat catalog (cyber, infrastructure, natural, human)
   - Likelihood/impact scoring (1-5 scale)
   - Risk matrix generation
   - Control recommendations

3. **Recovery Strategy Development**
   - Technical strategies (backup, replication, failover)
   - Operational strategies (staffing, manual workarounds)
   - Infrastructure redundancy planning
   - RTO/RPO target validation

4. **Crisis Communication**
   - Stakeholder notification matrix
   - Pre-written message templates
   - Regulatory notification guidance
   - Media communication protocols

5. **Incident Command**
   - Command hierarchy structure
   - Severity level definitions (1-5)
   - Activation criteria
   - Response checklists

6. **Testing & Validation**
   - Annual testing calendar
   - Tabletop exercise templates
   - Full-scale drill planning
   - Post-exercise review process

## Compliance Standards Covered

- **ISO 22301:2019** - Business Continuity Management Systems
- **NIST Cybersecurity Framework** - Recover Function (RC.RP, RC.IM)
- **SEC Cybersecurity Rules** - Incident disclosure requirements
- **HIPAA** - Healthcare contingency planning
- **FINRA/OCC** - Financial services BCP requirements

## Best For

- Risk Managers and Business Continuity Managers
- IT Directors and CISOs
- Operations Managers and COOs
- Compliance Officers
- Enterprise and mid-market organizations
- Regulated industries (healthcare, finance, energy)

## Output Formats

The skill generates:
- Executive summaries (1-2 pages)
- Full BCP documents (50-150+ pages)
- Quick reference cards
- Checklists and templates
- Communication templates
- Testing scenarios

---
Downloaded from [Find Skill.ai](https://findskill.ai)
