---
name: business-model-canvas-generator
version: 1.0.0
---

# Initialization

Design and validate business models using the 9-block Business Model Canvas framework created by Alexander Osterwalder and Yves Pigneur. This skill guides users through systematic analysis of Customer Segments, Value Propositions, Channels, Customer Relationships, Revenue Streams, Key Resources, Key Activities, Key Partnerships, and Cost Structure.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive BMC framework instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r business-model-canvas-generator/ ~/.claude/skills/business-model-canvas-generator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (starting from "You are an expert business strategist...")
3. Paste into your AI assistant

## Compatibility

Tested with: Claude, ChatGPT, Gemini, Copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{target_industry}}` | `SaaS` | Industry/sector for the business model |
| `{{target_market_maturity}}` | `early_stage` | Stage of company (idea, early_stage, growth, scaling) |
| `{{sustainability_focus}}` | `economic_only` | Level of sustainability integration |
| `{{customer_segment_primary}}` | `B2B` | Primary customer type (B2B, B2C, B2B2C, marketplace) |
| `{{time_to_validate}}` | `4_weeks` | Urgency of validation cycle |
| `{{revenue_model_type}}` | `subscription` | Preferred revenue model approach |

## Quick Start Examples

### Example 1: New SaaS Startup
```
I'm building an AI tool that helps remote teams generate marketing content in 10 minutes instead of hours. Target customers are marketing managers at 10-500 person companies who spend $500+/month on content creation. We charge $99/month with API access for enterprise. Create a BMC that explores both direct marketing and agency partnership channels.
```

### Example 2: Sustainable Fashion Brand
```
I'm launching a luxury sustainable fashion brand using Triple Layered Canvas. My value props are: zero-waste manufacturing, transparent supply chain, premium quality that lasts 10+ years. Target customers are affluent millennials (30-45) who value sustainability over fast fashion. Generate a BMC balancing economics, environmental impact, and social impact.
```

### Example 3: B2B SaaS Pivot Decision
```
Our B2B SaaS tool for HR compliance has 200 customers, $50K MRR, but growth stalled at 10% month-over-month. Our churn is 5%/month. We're considering three pivots: (1) double down on SMB with lower-touch sales, (2) pivot upmarket to enterprise with direct sales, (3) build platform partnerships. Create comparative BMCs for all three scenarios with unit economics.
```

## Key Concepts

- **Customer Segments**: Groups of customers with distinct needs and behaviors
- **Value Proposition**: The bundle of products/services that create value
- **Channels**: How you reach and deliver value to customers
- **Customer Relationships**: Types of interactions with customer segments
- **Revenue Streams**: How you generate cash from customer segments
- **Key Resources**: Essential assets required to operate
- **Key Activities**: Core operations to make the model work
- **Key Partnerships**: Network of suppliers and partners
- **Cost Structure**: All costs to operate the business model

## Related Skills

- Business Plan Generator - Create full business plans from BMC
- Pitch Deck Creator - Turn BMC into investor presentations
- Competitive Analysis - Map competitor business models
- Financial Projections - Build forecasts from revenue streams

---
Downloaded from [Find Skill.ai](https://findskill.ai)
