---
name: capex-vs-opex-evaluator
version: 1.0.0
---

# Initialization

CapEx vs OpEx Evaluator - A comprehensive skill for analyzing lease vs. buy, cloud vs. on-premises, and build vs. outsource decisions using TCO modeling, NPV analysis, and risk assessment frameworks.

## Structure

- `SKILL.md` - Main skill prompt with complete decision frameworks

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r capex-vs-opex-evaluator/ ~/.claude/skills/capex-vs-opex-evaluator/
```

### ChatGPT / GPT-4
1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into Custom Instructions or as a system prompt in a new conversation

### Gemini
1. Open `SKILL.md`
2. Copy all content after the frontmatter
3. Paste as the initial context in a new conversation

### Copilot
1. Open `SKILL.md`
2. Copy all content after the frontmatter
3. Use in a custom prompt or conversation starter

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `analysis_horizon_years` | `5` | Time period for financial analysis (3-10 years) |
| `annual_discount_rate` | `0.10` | Cost of capital or hurdle rate for NPV calculations |
| `annual_cost_inflation_rate` | `0.03` | Expected annual increase in operating costs |
| `technology_refresh_cycle_years` | `4` | Expected lifespan before technology becomes obsolete |
| `annual_maintenance_pct` | `0.08` | Annual maintenance as percentage of purchase price |
| `residual_value_pct` | `0.20` | Expected resale/salvage value as percentage of purchase |

## Example Usage

**Equipment Decision:**
```
We need to decide whether to buy a $180,000 CNC machine outright or lease
it for $24,000/year. The machine has a 10-year lifespan, estimated annual
maintenance of $12,000 if we own it (included in lease), and we expect
15% residual value. Our cost of capital is 9%. Which option is better
financially, and at what maintenance cost would the decision flip?
```

**Cloud vs. On-Premises:**
```
Our startup is deciding: invest $2M in on-premises server infrastructure
vs. use AWS. On-prem requires $400K annually to operate and manage.
AWS would cost us $60K/month. We're growing 50% year-over-year.
What's the break-even, and which should we choose?
```

**Build vs. Buy:**
```
We have 500 employees. We can: (A) Build custom HR software for $200K
development cost + $80K annual maintenance, or (B) Buy Workday for
$100/employee/year ($50K/year), with estimated 100 hours of internal
configuration work annually. Our employees cost $100/hour fully loaded.
Growth is 20% annually for next 3 years. Which option is better?
```

## Capabilities

1. **Equipment Purchase vs. Lease Analysis** - Compare upfront purchase costs against recurring lease payments with NPV and break-even analysis

2. **Cloud vs. On-Premises Infrastructure** - Evaluate data center CapEx versus cloud OpEx with scalability modeling

3. **Software Build vs. Buy vs. Outsource** - Assess custom development against COTS solutions and outsourced alternatives

4. **Total Cost of Ownership (TCO) Modeling** - Create comprehensive multi-year financial models

5. **Risk and Flexibility Trade-off Analysis** - Quantify vendor lock-in, obsolescence, and control trade-offs

6. **Tax and Accounting Impact** - Understand CapEx depreciation vs. OpEx immediate expensing

7. **Sensitivity and Scenario Modeling** - Test assumptions and identify decision thresholds

## Key Concepts Covered

- Capital Expenditure (CapEx) vs. Operating Expenditure (OpEx)
- Total Cost of Ownership (TCO)
- Net Present Value (NPV) and discounting
- Depreciation methods and tax shields
- Weighted Average Cost of Capital (WACC)
- Technology obsolescence risk
- Vendor lock-in assessment
- Life Cycle Cost Analysis (LCCA)
- Sensitivity analysis techniques

---
Downloaded from [Find Skill.ai](https://findskill.ai)
