---
name: career-pivot-risk-calculator
version: 1.0.0
---

# Initialization

Career Pivot Risk Calculator - A systematic risk assessment tool for evaluating career transition viability. Analyzes financial runway, skills transferability, market conditions, reversibility, and personal alignment to provide data-driven recommendations for career pivots.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive career transition risk assessment instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r career-pivot-risk-calculator/ ~/.claude/skills/career-pivot-risk-calculator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (starting from "You are an expert Career Transition Analyst...")
3. Paste into your AI assistant's system prompt or custom instructions

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Core Capabilities

1. **Financial Runway Assessment** - Calculate months of sustainable income, expense coverage, and savings needed for transition
2. **Skills Gap Analysis** - Identify transferable skills and quantify learning requirements vs. career advancement potential
3. **Market Viability Scoring** - Evaluate industry growth, demand, salary trajectories, and competitive landscape
4. **Reversibility Assessment** - Distinguish between irreversible career moves vs. low-risk testing opportunities
5. **Personal-Professional Alignment** - Map values, work style, and lifestyle goals against target career requirements
6. **Risk-Reward Matrix** - Synthesize assessments into actionable pathway recommendations

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{financial_runway_months}}` | `12` | Target months of expense coverage from savings |
| `{{target_salary_adjustment_percent}}` | `-30` | Expected salary change entering target career |
| `{{skill_gap_assessment_scale}}` | `5` | Rating of skills gap severity (1=minimal, 10=major) |
| `{{market_growth_rate_annual}}` | `8` | Expected annual growth rate of target industry |
| `{{emotional_capacity_rating}}` | `7` | Self-assessed ability to handle transition stress (1-10) |
| `{{risk_tolerance_level}}` | `medium` | Overall risk tolerance (low/medium/high) |

## Example Usage

```
"I've been a Product Manager at a tech company for 8 years earning $150k.
I want to transition to Data Science because I'm fascinated by ML and
data-driven work. I have a CS degree but haven't coded in years. I have
$80k in savings and my monthly expenses are $5k. Can you assess my career
pivot risk and recommend a transition strategy?"
```

## Key Concepts

- **Financial Runway**: Months of sustainability without income
- **Transferable Skills**: Competencies applicable across industries
- **Gateway Roles**: Intermediate positions bridging current and target careers
- **Reversibility**: Ability to undo career decisions without significant loss
- **Time-to-Proficiency**: Duration to reach competency in target role
- **Income Recovery Timeline**: Timeframe to return to current income levels
- **Career SWOT Analysis**: Strengths, Weaknesses, Opportunities, Threats assessment

## Recommended Workflow

1. **Initial Assessment** (15 min)
   - Gather current role, salary, savings, expenses
   - Understand target career and motivation
   - Calculate preliminary risk score

2. **Deep Analysis** (30-45 min)
   - Financial runway calculation
   - Skills gap analysis
   - Market viability assessment
   - Reversibility evaluation
   - Personal alignment check

3. **Action Planning** (15 min)
   - Generate pathway options
   - Create 90-day action plan
   - Set decision checkpoints

## Related Skills

- Resume & Job Search Coach - Optimize job search after pivot
- Salary Negotiation Coach - Negotiate in new field
- LinkedIn Profile Optimizer - Rebrand for career change
- Personal Budget Coach - Build financial runway
- Goal Framework Strategist - Set transition milestones

---
Downloaded from [Find Skill.ai](https://findskill.ai)
