---
name: co-founder-vetting-checklist
version: 1.0.0
---

# Initialization

Systematically evaluate potential co-founders across values alignment, complementary skills, communication style, emotional resilience, and long-term compatibility before formalizing business partnerships. Prevents the 65% of startup failures caused by founder conflict.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive co-founder vetting frameworks

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r co-founder-vetting-checklist/ ~/.claude/skills/co-founder-vetting-checklist/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (starting from "You are an expert co-founder vetting advisor...")
3. Paste into your AI assistant's system prompt or custom instructions

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{trial_project_duration_days}}` | `60` | Duration of working trial period before formal commitment |
| `{{vesting_period_years}}` | `4` | Total vesting timeline for founder equity |
| `{{cliff_period_months}}` | `12` | Cliff period before any shares vest |
| `{{communication_sync_frequency}}` | `bi-weekly` | How often co-founders meet for strategic check-ins |
| `{{personality_assessment_tool}}` | `Big Five` | Which psychometric tool to use for compatibility |
| `{{equity_split_primary}}` | `50/50` | Primary equity allocation model |

## Core Capabilities

1. **Values & Vision Alignment Assessment** - Evaluate shared business philosophy, long-term goals, exit preferences, and company culture aspirations

2. **Complementary Skills Matrix** - Map skill gaps and validate candidate expertise in critical startup functions (technical, business, marketing, operations)

3. **Communication Style Evaluation** - Assess conflict handling, feedback receptivity, and emotional intelligence using personality frameworks

4. **Trial Working Period Framework** - Design 60-90 day structured projects to stress-test partnership before equity commitments

5. **Failure Recovery Profile** - Evaluate resilience, growth mindset, and accountability patterns through past setback analysis

6. **Founder Agreement Formalization** - Guide equity splits, vesting schedules, role definitions, and legal documentation

## Example Usage

"I'm considering partnering with someone I met at a startup event 3 months ago. We've had several coffee chats and she has strong product management experience while I'm technical. Help me systematically vet whether we'd be good co-founders - I want to assess values alignment, complementary skills, communication compatibility, and establish a trial working period framework."

## Research Sources

- How To Choose A Co-Founder (Elad Gil): https://blog.eladgil.com/p/how-to-choose-co-founder
- Why Cofounder Partnerships Fail (HBR): https://hbr.org/2024/06/why-cofounder-partnerships-fail-and-how-to-make-them-last
- A Step-by-Step Guide to Vetting a Potential Cofounder: https://onlyfounders.app/all-blogs/a-step-by-step-guide-to-vetting-a-potential-cofounder
- Founders Agreement Template Guide: https://deliberatedirections.com/founders-agreement-template/
- 6 Communication Strategies for Co-founders in Conflict: https://vncmd.com/en/business/6-communication-strategies-for-co-founders-in-conflict/

---
Downloaded from [Find Skill.ai](https://findskill.ai)
