---
name: content-calendar-optimizer
version: 1.0.0
---

# Initialization

Content Calendar Optimizer - A comprehensive skill for building sustainable content production systems that prevent burnout through batch workflows, capacity planning, and strategic calendar optimization.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with complete instructions for content calendar optimization

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None required. Optional integrations:
- Calendar tools (Google Calendar, Notion, Asana, Monday.com)
- Scheduling tools (Buffer, Hootsuite, Later, ContentStudio)
- Analytics platforms (Google Analytics, social platform native analytics)

## Post-Init Steps

### Claude Code
```bash
cp -r content-calendar-optimizer/ ~/.claude/skills/content-calendar-optimizer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy all content after the YAML frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or as an initial message

### Quick Start
After installing, start a conversation with:
- "I need help building a sustainable content calendar for the next quarter"
- "I'm experiencing content burnout - help me audit my workload"
- "Design a batch production schedule for my content"

## Compatibility

Tested and verified with:
- Claude (Opus, Sonnet, Haiku)
- ChatGPT (GPT-4, GPT-4o)
- Gemini (Pro, Advanced)
- GitHub Copilot Chat

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{planning_horizon_weeks}}` | `13` | Number of weeks to plan ahead (4-52) |
| `{{batch_production_days}}` | `1` | Days per batch session (0.5-3) |
| `{{posting_cadence}}` | `blog:2, email:1, instagram:4, linkedin:3` | Weekly posting frequency per channel |
| `{{content_mix_split}}` | `70/20/10` | Evergreen/timely/promotional percentages |
| `{{team_capacity_hours}}` | `40` | Weekly hours available for content production |
| `{{content_pillars}}` | `Educational, Community, Product, Inspiration` | Core content themes (3-5) |

## Use Cases

### Solo Creators
- Design sustainable posting schedules that prevent burnout
- Batch content production for 1-2 weeks at a time
- Repurpose high-performing content across channels

### Marketing Teams
- Quarterly content strategy planning with business alignment
- Workload distribution across team members
- Approval workflow optimization

### Agencies
- Multi-client calendar management
- Template libraries for efficient production
- Capacity tracking and resource allocation

### Anyone Experiencing Burnout
- Workload audit and immediate relief actions
- Sustainable frequency reduction plans
- Recovery protocols and monitoring

## Core Capabilities

1. **Quarterly Content Strategy Planning** - 13-week strategic plans with pillars, mix, and cadence
2. **Batch Production Planning** - Efficient content creation sessions
3. **Workload Audit & Burnout Prevention** - Diagnose overload and design sustainable systems
4. **Content Repurposing Strategy** - Maximum ROI from every piece
5. **Performance Analytics & Iteration** - Data-driven optimization

---
Downloaded from [Find Skill.ai](https://findskill.ai)
