---
name: corporate-language-translator
version: 1.0.0
description: Transform raw emotional thoughts into polished workplace communications
author: FindSkill.ai
license: MIT
---

# Initialization

Transform raw, emotional workplace thoughts into polished professional communications that get results without burning bridges.

## Overview

This is a prompt-only skill that helps users navigate workplace politics by converting honest feelings into appropriate professional language. No scripts or additional files are required.

**Time to initialize**: Instant (no setup required)

## Directory Structure

```
corporate-language-translator/
├── SKILL.md    # Main skill prompt
└── INIT.md     # This file
```

## Dependencies

None - this is a prompt-only skill.

## Files to Generate

None - simply use SKILL.md directly.

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r corporate-language-translator/ ~/.claude/skills/corporate-language-translator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: Claude, ChatGPT, Gemini, Copilot

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `raw_message` | (empty) | Your honest, unfiltered thought or feeling |
| `context` | colleague | Who you're communicating with |
| `medium` | email | Communication channel (email, Slack, Teams, meeting) |
| `desired_outcome` | address the issue professionally | What you want to achieve |

## Use Cases

This skill excels at:
- Transforming angry venting into constructive feedback
- Converting passive-aggressive thoughts into direct communication
- Helping non-native speakers sound naturally professional
- Navigating tricky workplace politics
- Setting boundaries without burning bridges
- Addressing credit-taking and unfair treatment professionally
- Following up persistently without being annoying

## Example Transformations

**Input**: "My coworker is such an idiot and keeps making me fix his mistakes"
**Output**: "I'd like to discuss establishing clearer quality checks for our shared deliverables"

**Input**: "This deadline is ridiculous and whoever set it has no idea what they're doing"
**Output**: "I have some concerns about the timeline and would like to discuss what's feasible"

**Input**: "Stop CCing my boss on everything, it's so passive aggressive"
**Output**: "I'd prefer to keep our communications direct unless escalation is needed"

---
Downloaded from [FindSkill.ai](https://findskill.ai)
