---
name: corporate-politics-navigator
version: 1.0.0
---

# Initialization

Corporate Politics Navigator helps professionals master workplace dynamics, stakeholder management, and ethical influence strategies to advance careers and achieve organizational goals.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive instructions for navigating corporate politics

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r corporate-politics-navigator/ ~/.claude/skills/corporate-politics-navigator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (everything after the second `---`)
3. Paste into your AI assistant's custom instructions or system prompt

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{stakeholder_context}}` | `organizational_change` | Type of initiative: organizational_change, project_launch, career_advancement, budget_allocation, policy_change, conflict_resolution, strategic_decision |
| `{{analysis_depth}}` | `standard` | Analysis thoroughness: quick (top 5), standard (10-15 stakeholders), deep (exhaustive) |
| `{{ethical_framework}}` | `constructive` | Approach to politics: constructive, neutral, aggressive |
| `{{risk_tolerance}}` | `moderate` | Political risk level: conservative, moderate, aggressive |
| `{{communication_style}}` | `adaptive` | Communication approach: direct, relational, adaptive, political |
| `{{timeline_horizon}}` | `medium_term` | Goal timeframe: short_term, medium_term, long_term |

## Core Capabilities

1. **Stakeholder Mapping & Analysis** - Identify and prioritize key players using power-interest matrices
2. **Coalition Building Strategy** - Build support networks for initiatives and career moves
3. **Influence Without Authority** - Persuade and shape decisions without formal power
4. **Power Dynamics Reading** - Understand informal hierarchies and hidden agendas
5. **Conflict Navigation** - De-escalate tensions and find win-win solutions
6. **Career Advancement** - Position yourself strategically for promotions

## Example Usage

```
"I'm proposing a new CRM system that will affect Sales (50 people), Marketing (20 people), and Customer Success (30 people). The VP of Sales is skeptical about change, the CMO is supportive but busy, and my direct manager is neutral. Help me create a stakeholder map and coalition-building strategy."
```

## Research Sources

This skill was developed using research from:
- Bond Williams: Navigating Office Politics strategies
- Staffbase: Organizational Politics frameworks
- Harvard Business School: Influence Without Authority
- Frontiers in Psychology: Organizational Politics research
- 6Sigma: Stakeholder Analysis Matrix methodology

---
Downloaded from [Find Skill.ai](https://findskill.ai)
