---
name: corporate-speak-decoder
version: 1.0.0
---

# Corporate Speak Decoder - Initialization

Decode corporate emails and jargon into three formats: literal meaning, Gen Z translation, and brutally honest interpretation. Helps Gen Z workers, career changers, and international professionals understand what colleagues really mean.

## Package Structure

```
corporate-speak-decoder/
├── SKILL.md    # Main skill prompt (copy this to your AI)
└── INIT.md     # This file - setup instructions
```

## Files to Generate

None required - this is a prompt-only skill.

## Installation

### Claude Code
```bash
# Copy to your Claude Code skills directory
cp -r corporate-speak-decoder/ ~/.claude/skills/corporate-speak-decoder/

# Add to your CLAUDE.md or use directly
```

### ChatGPT / GPT-4
1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into ChatGPT as your system prompt or custom instructions
4. Start a new conversation with your corporate email to decode

### Claude.ai (Web)
1. Open `SKILL.md`
2. Copy all content after the frontmatter
3. Start a new conversation
4. Paste the skill content, then add your corporate email below it

### Gemini
1. Open `SKILL.md`
2. Copy all content after the frontmatter
3. Paste into Gemini conversation
4. Follow up with the corporate text you want decoded

### GitHub Copilot
1. Open `SKILL.md`
2. Copy content to your project's AI instructions file
3. Reference when needed for communication analysis

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{translation_depth}}` | `full` | How detailed: minimal, moderate, or full analysis |
| `{{target_audience_age}}` | `millennial` | Adjust slang: gen_z, millennial, gen_x |
| `{{company_industry}}` | `tech` | Industry context: tech, finance, healthcare, nonprofit |
| `{{tone_directness}}` | `moderate` | Honest translation bluntness: mild, moderate, savage |
| `{{include_response}}` | `true` | Generate suggested responses: true, false |
| `{{emotion_analysis}}` | `basic` | Emotional subtext depth: none, basic, advanced |

## Quick Start Examples

### Example 1: Decode a Manager Email
```
I just got this email from my manager:

"Hi team, I wanted to circle back on our earlier conversation about the Q4 roadmap.
After further alignment with leadership, we've decided to pivot our approach.
Going forward, we'll need to right-size our expectations and focus on quick wins
that move the needle. Let's touch base next week to ensure we're all rowing in
the same direction."

What does this actually mean? I'm new to corporate jobs.
```

### Example 2: Understand a Passive-Aggressive Message
```
Got this Slack message from a coworker:

"Hey! Hope you're having a great week. Just wanted to follow up on the
deliverables from last sprint - I know you've been super busy, but the
team is really counting on those updates. Let me know if there's anything
blocking you! Thanks in advance for your help on this."

Is this passive-aggressive or am I overthinking?
```

### Example 3: Decode an Email Chain Conflict
```
[Paste a back-and-forth email thread]

I feel like there's tension here but everyone's being "nice."
What's actually going on and whose side should I be on?
```

## Core Capabilities

1. **Single Email Translation** - Three-format decode with jargon highlighting
2. **Jargon Lookup** - Define specific phrases with danger levels
3. **Email Chain Decoder** - Map conflicts and power dynamics
4. **Response Generator** - Multiple tone options with risk assessment
5. **Meeting Notes Translator** - Real action items vs. political theater

## Post-Init Verification

Test your installation by sending this prompt:

```
Decode this: "Let's take this offline and circle back when we have more bandwidth.
I'll loop in stakeholders once we've aligned on next steps."
```

Expected output should include:
- Literal translation (plain English version)
- Gen Z translation (modern slang version)
- Honest translation (what they're really thinking)
- Jargon breakdown (each phrase explained)

## Related Skills

- **Corporate Language Translator** - The reverse: convert raw thoughts INTO corporate speak
- **Difficult Workplace Conversations** - Handle challenging discussions
- **Corporate Politics Navigator** - Understand power dynamics
- **Managing Up Communication Coach** - Communicate with your manager

## Troubleshooting

| Issue | Solution |
|-------|----------|
| Missing Gen Z translations | Ensure `target_audience_age` is set to `gen_z` |
| No response suggestions | Set `include_response` to `true` |
| Too brief analysis | Set `translation_depth` to `full` |
| Missing emotional analysis | Set `emotion_analysis` to `advanced` |

## Updates

Check [Find Skill.ai](https://findskill.ai/skills/productivity/corporate-speak-decoder/) for the latest version and community feedback.

---
Downloaded from [Find Skill.ai](https://findskill.ai)
