---
name: couples-financial-alignment-tool
version: 1.0.0
---

# Initialization

Help romantic partners with different financial personalities achieve financial harmony through evidence-based personality assessments, shared goal frameworks, account structure design, and conflict-free money conversations.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive instructions for couple's financial alignment coaching

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r couples-financial-alignment-tool/ ~/.claude/skills/couples-financial-alignment-tool/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (starting from "You are an expert...")
3. Paste into your AI assistant

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{monthly_joint_income}}` | `$6,500` | Combined monthly after-tax household income |
| `{{discretionary_allowance_percent}}` | `7%` | Percentage of income each partner gets as judgment-free personal spending |
| `{{joint_savings_target_percent}}` | `20%` | Percentage of income allocated to shared savings goals |
| `{{major_purchase_threshold}}` | `$500` | Dollar amount above which purchases require joint discussion |
| `{{financial_review_frequency}}` | `monthly` | How often to formally review finances together |
| `{{money_personality_weight}}` | `high` | How much to accommodate different money types in planning |

## Use Cases

1. **Newly Committed Couples**: Establish financial communication patterns, discover money personalities, create first shared goals
2. **Couples in Conflict**: Understand root causes of money fights, reframe differences as complementary, build non-judgmental communication
3. **Blending Finances**: Design fair account structures for wealth gaps, navigate debt discussions, establish contribution models
4. **Life Milestone Planning**: Align on home purchases, retirement timing, children costs with buy-in from both partners
5. **System Optimization**: Fine-tune existing arrangements, strengthen review cadence, deepen goal alignment

## Research Foundation

This skill is grounded in peer-reviewed research including:
- UGA study (602 couples) on financial satisfaction predictors
- UK Government qualitative study on household financial decision-making
- MARS study (435 couples) on debt concordance and relationship quality
- Behavioral economics research on present bias and joint decision-making

## Key Capabilities

1. **Money Personality Assessment** - Identify types (Planner, Experiencer, Giver, Analyst, Avoider, Status) with origin exploration
2. **Account Structure Design** - Full merger vs. separation vs. hybrid with contribution models
3. **Shared Goal Creation** - SMART framework adapted for couples with different priorities
4. **Decision Framework** - Clear protocols for who decides what at different spending levels
5. **Conflict Resolution** - Non-judgmental communication scripts and cooling-off protocols
6. **Budget Method Matching** - 50/30/20, zero-based, value-based matched to personality types
7. **Review Systems** - Monthly money dates and annual planning sessions

---
Downloaded from [Find Skill.ai](https://findskill.ai)
