---
name: cross-team-blocker-escalation
version: 1.0.0
description: Escalate cross-functional blockers professionally while preserving relationships
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill helps professionals escalate cross-team blockers effectively using the BRIDGE framework (Business Impact, Resolution Attempts, Issue Description, Deadline Pressure, Get Specific, Easy Path) while maintaining positive working relationships.

**Time to initialize**: ~1 minute (prompt-only skill)

## Directory Structure

```
cross-team-blocker-escalation/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization file
```

## Dependencies

None (prompt-only skill)

## Files to Generate

None - this is a prompt-only skill. Copy SKILL.md content directly to your AI assistant.

## What This Skill Covers

### Escalation Framework
- BRIDGE structure for effective escalations
- 4-level escalation ladder
- Timing guidelines for when to escalate
- Neutral language transformation

### Templates Included
- Level 1: Peer-to-peer direct ask
- Level 2: Manager loop escalation
- Level 3: Joint escalation to leadership
- Post-escalation follow-up guidance

### Key Principles
- Focus on facts, not blame
- Quantify business impact
- Document resolution attempts
- Make specific, actionable asks
- Preserve relationships

## Usage Instructions

### For Claude Code

```bash
# Copy to your skills directory
cp -r cross-team-blocker-escalation/ ~/.claude/skills/cross-team-blocker-escalation/
```

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or conversation

### Quick Start

Tell the AI:
- What's blocked and who's blocking it
- The business impact (timeline, revenue, customers)
- What you've already tried to resolve it
- Who you're escalating to
- Any political considerations

The AI will generate an appropriate escalation message for your situation.

## Customization Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{blocker_description}}` | `API integration dependency` | What is blocked |
| `{{blocking_team}}` | `Platform Team` | Team causing the blocker |
| `{{business_impact}}` | `3-week delay to product launch` | Impact of the blocker |
| `{{attempted_resolution}}` | `direct outreach, attended their standup` | What I've already tried |

## Example Request

```
I've been waiting 2 weeks for the Data Engineering team to provide the analytics
API we need for our dashboard feature. I've asked twice in Slack and attended
their planning meeting but they say they're "too busy with migration work."
Meanwhile, our Q1 launch is at risk - we promised the VP we'd ship by Feb 15.

Help me write an escalation to their manager that gets this prioritized without
making enemies. I'll probably need to work with them on future projects.
```

## Compatibility

Tested with:
- Claude (Anthropic)
- ChatGPT (OpenAI)
- Gemini (Google)
- Copilot (Microsoft)

## Post-Init Verification

After setup, test with: "Help me escalate a blocker where the Platform team hasn't delivered the API spec we need, and we've been waiting 10 days. Our product launch is at risk."

---
Downloaded from [Find Skill.ai](https://findskill.ai)
