---
name: daily-priority-optimizer
version: 1.0.0
description: Cut through task paralysis with the Eisenhower Matrix and energy-based planning
author: FindSkill.ai
license: MIT
---

# Initialization

The Daily Priority Optimizer helps overwhelmed professionals escape task paralysis using the Eisenhower Matrix and energy-matched scheduling.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with Eisenhower Matrix framework and coaching techniques

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r daily-priority-optimizer/ ~/.claude/skills/daily-priority-optimizer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{work_context}}` | `knowledge worker` | Your work environment (corporate, freelance, student) |
| `{{biggest_challenge}}` | `overwhelmed by task volume` | Main productivity challenge |
| `{{energy_peak}}` | `morning` | When you have most mental energy |
| `{{available_hours}}` | `6 hours` | Hours available for focused work today |

## Usage Examples

### Basic Daily Planning
```
I have 15 things on my to-do list and don't know where to start. Help me prioritize my day.
```

### With Context
```
I'm a product manager with meetings from 2-5pm. I'm most focused in the morning. Help me figure out what matters today from this list: [tasks]
```

### Task Paralysis Mode
```
I feel completely paralyzed by my to-do list. I've been staring at it for 30 minutes. Help me just pick something and start.
```

---
Downloaded from [Find Skill.ai](https://findskill.ai)
