---
name: debt-elimination-sequencer
version: 1.0.0
---

# Initialization

Debt Elimination Sequencer helps users systematically eliminate debt using research-backed strategies that balance mathematical optimization with psychological sustainability. It combines Snowball, Avalanche, and Cascade methods with behavioral nudges and motivation checkpoints.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive debt elimination strategies, personality assessment, and 5 detailed workflows

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r debt-elimination-sequencer/ ~/.claude/skills/debt-elimination-sequencer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (everything below the second `---`)
3. Paste into your AI assistant

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Core Capabilities

1. **Debt Inventory & Assessment** - Compile all debts, calculate total owed, identify interest rates
2. **Strategy Comparison** - Model Snowball, Avalanche, and Cascade strategies with projected timelines
3. **Timeline Modeling** - Calculate months to debt freedom under different payment amounts
4. **Motivation Checkpoint Design** - Create milestone calendar with celebration prompts
5. **Strategy Pivot Analysis** - Assess when to switch strategies based on adherence
6. **Behavioral Troubleshooting** - Diagnose obstacles and design interventions

## Research Foundation

Based on peer-reviewed behavioral economics research:
- 89% debt aversion rate with 16% borrowing premium
- Behavioral nudges reduce delinquency by 0.42pp (13-million-person study)
- Small wins theory for motivation sustainability
- Hybrid Cascade achieves 75-85% adherence vs 35-40% for pure Avalanche

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{strategy_type}}` | `cascade` | Payoff strategy: snowball, avalanche, or cascade |
| `{{monthly_payment_allocation}}` | `$1,200` | Extra monthly amount beyond minimums |
| `{{checkpoint_frequency}}` | `monthly` | Progress check interval |
| `{{personality_type}}` | `balanced` | User motivation profile |
| `{{timeline_confidence}}` | `0.85` | Confidence level for projections |
| `{{celebration_style}}` | `psychological` | How milestones are celebrated |

## Example Usage

```
I have $52,000 in debt spread across:
- Credit card 1: $8,500 at 21.5% APR, minimum $200/month
- Credit card 2: $4,200 at 18.2% APR, minimum $120/month
- Car loan: $22,000 at 5.9% APR, minimum $420/month
- Student loan: $17,300 at 4.1% APR, minimum $180/month

My take-home income is $4,200/month. After expenses, I have about $900/month extra.

I've tried paying debt before but lost motivation. I need a strategy that shows progress quickly.
```

## Related Skills

- **Budget Planner** - Creates spending plan to maximize debt allocation
- **Financial Goal Tracker** - Track debt payoff milestones
- **Expense Categorizer** - Find extra money for debt payments
- **Bill Negotiation Scripts** - Lower bills to free up cash

---
Downloaded from [Find Skill.ai](https://findskill.ai)
