---
name: "Deep Research Prompt Framework"
version: "1.0"
---

# Initialization Manifest

## Purpose

Teaches users how to craft AI prompts that produce thorough, multi-source, citation-backed research. Provides the 8-component prompt anatomy, 5 ready-to-use templates, 4 multi-step chaining strategies, and platform-specific optimization tips for ChatGPT, Claude, Gemini, Perplexity, and Copilot.

## Structure

| Section | Content |
|---------|---------|
| 1. Role and Approach | 5 core principles: structure over length, specificity multiplies quality, citations non-negotiable, depth-breadth trade-offs, prompt is the product |
| 2. Research Prompt Anatomy | 8 components: persona (with selection guide), PICO question framing, scope boundaries, depth matrix (4 levels), citation formats (4 options), output structures (5 templates), quality guardrails, anti-hallucination safeguards |
| 3. Depth vs Breadth | 4 strategies: single comprehensive, multi-step chain, parallel investigation, progressive refinement |
| 4. Prompt Templates | 5 use-case templates: technology assessment, competitive landscape, policy research, investment due diligence, literature review |
| 5. Multi-Step Chains | 4 chain patterns: funnel (broad-to-narrow), adversarial (pro-vs-con), temporal (past-present-future), multi-stakeholder |
| 6. Synthesis Techniques | 4 methods: thematic clustering, evidence pyramid, contradiction resolution, implication mapping |
| 7. Platform Tips | Optimization for ChatGPT (browsing), Claude (long context), Gemini (deep research), Perplexity (citations), Copilot (Bing) |
| 8. Common Mistakes | 6 failure patterns with fixes: everything prompt, naked question, citation afterthought, false precision, confirmation bias, time blindness |
| 9. Assembly Workflow | 7-step interactive process: intake, frame, select template, customize, add guardrails, review, deliver |
| 10. Advanced Techniques | 5 techniques: structured disagreement, confidence calibration, source triangulation, temporal anchoring, methodology transparency |
| 11. Response Workflow | Interactive coaching flow with greeting and 4-question intake |

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r deep-research-prompt-framework/ ~/.claude/skills/deep-research-prompt-framework/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: Claude, ChatGPT, Gemini, Copilot, Perplexity

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{my_research_topic}}` | (required) | Research topic or question to investigate |
| `{{my_depth_level}}` | `deep dive` | Desired depth (quick scan, balanced overview, deep dive, exhaustive report) |
| `{{my_audience}}` | `general` | Intended audience (executive, academic, general, technical) |
| `{{my_citation_style}}` | `inline numbered` | Citation format (inline numbered, APA, footnotes, hyperlinked) |
| `{{my_output_format}}` | `full report` | Output structure (executive brief, full report, annotated bibliography, comparison table) |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
