---
title: "Deep Research Prompt Framework"
description: "Master the art of crafting deep research prompts for AI. Structured frameworks for getting thorough, multi-source, citation-backed research from any AI assistant."
version: "1.0"
platforms: ["claude", "chatgpt", "gemini", "copilot", "perplexity"]
difficulty: "intermediate"
variables:
  - my_research_topic: "Research topic or question to investigate"
  - my_depth_level: "Desired depth (quick scan, balanced overview, deep dive, exhaustive report)"
  - my_audience: "Intended audience (executive, academic, general, technical)"
  - my_citation_style: "Citation format (inline numbered, APA, footnotes, hyperlinked)"
  - my_output_format: "Output structure (executive brief, full report, annotated bibliography, comparison table)"
---

# Deep Research Prompt Framework

## What This Skill Does

Teaches you how to craft AI prompts that produce thorough, multi-source, citation-backed research. Instead of getting shallow summaries, you'll build structured prompts using the 8-component framework that reliably extracts deep investigations from ChatGPT, Claude, Gemini, Perplexity, or any AI.

## 11 Sections Covered

1. **Role and Approach** -- Core principles: structure over length, specificity multiplies quality, citations non-negotiable, depth vs breadth trade-offs
2. **Research Prompt Anatomy** -- 8 components: persona, question framing (PICO), scope boundaries, depth specification, citation requirements, output structure, quality guardrails, anti-hallucination safeguards
3. **Depth vs Breadth Strategies** -- 4 strategies: single comprehensive, multi-step chain, parallel investigation, progressive refinement
4. **Prompt Templates** -- 5 ready-to-use templates: technology assessment, competitive landscape, policy research, investment due diligence, literature review
5. **Multi-Step Research Chains** -- 4 chain patterns: funnel (broad to narrow), adversarial (pro vs con), temporal (past-present-future), multi-stakeholder
6. **Synthesis Techniques** -- 4 methods: thematic clustering, evidence pyramid, contradiction resolution, implication mapping
7. **Platform-Specific Tips** -- Optimization for ChatGPT, Claude, Gemini, Perplexity, Copilot
8. **Common Mistakes** -- 6 failure patterns: everything prompt, naked question, citation afterthought, false precision, confirmation bias, time blindness
9. **Prompt Assembly Workflow** -- 7-step process: intake, frame, select template, customize, add guardrails, review, deliver
10. **Advanced Techniques** -- 5 techniques: structured disagreement, confidence calibration, source triangulation, temporal anchoring, methodology transparency
11. **Response Workflow** -- Interactive coaching flow for building custom research prompts

## How to Use

1. Copy the skill and paste into your AI assistant
2. Describe your research topic and answer the intake questions
3. Receive a custom research prompt built from the 8-component framework
4. Copy the generated prompt and use it with any AI for deep research

## Key Frameworks

- **PICO Question Framing**: Population, Intervention, Comparison, Outcome
- **8-Component Prompt Anatomy**: Persona, Question, Scope, Depth, Citations, Structure, Guardrails, Anti-Hallucination
- **Depth Matrix**: Quick Scan (300-500w) to Exhaustive Report (3000-6000w)
- **4 Chain Patterns**: Funnel, Adversarial, Temporal, Multi-Stakeholder

---
Downloaded from [Find Skill.ai](https://findskill.ai)
