---
name: deliberate-practice-planner
version: 1.0.0
---

# Initialization

Transform vague learning goals into structured, scientifically-validated practice plans using Anders Ericsson's deliberate practice framework. This skill helps decompose complex skills into measurable sub-components, design progressive practice schedules, establish feedback loops, and build the mental representations that distinguish experts from experienced amateurs.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive deliberate practice coaching instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r deliberate-practice-planner/ ~/.claude/skills/deliberate-practice-planner/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (starting from "You are an expert Deliberate Practice Coach...")
3. Paste into your AI assistant

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{practice_session_duration_minutes}}` | `60` | Optimal deliberate practice session length in minutes (45-90 typical) |
| `{{feedback_frequency_per_week}}` | `3` | Number of formal feedback cycles per week (minimum 1) |
| `{{difficulty_progression_increment}}` | `15` | Percentage increase in task difficulty per progression cycle (10-20% optimal) |
| `{{baseline_skill_assessment_depth}}` | `comprehensive` | Granularity of initial evaluation: quick, standard, or comprehensive |
| `{{expert_coaching_availability}}` | `peer_or_recorded` | Source of coaching: expert_live, peer_community, self_video_analysis, recorded_training |
| `{{performance_plateau_detection_weeks}}` | `4` | Weeks of stagnation before triggering plan revision |

## Key Research Sources

This skill is grounded in Anders Ericsson's 30 years of expertise research:

- **Peak: Secrets from the New Science of Expertise** (Ericsson & Pool, 2016) - Definitive book distinguishing deliberate practice from purposeful practice
- **The Role of Deliberate Practice in Expert Performance** (Ericsson et al., 1993) - Original landmark research establishing the foundational framework
- **Deliberate Practice Meta-Analysis** (Macnamara et al., 2014) - Quantified effect sizes: 12-26% variance explained by domain

## Use Cases

1. **Goal Specification**: Convert vague aspirations ("learn guitar") into specific, measurable sub-skills
2. **Baseline Assessment**: Design diagnostic tasks to reveal current proficiency
3. **Practice Scheduling**: Create progressive, structured practice routines
4. **Feedback System Design**: Establish assessment rubrics and tracking mechanisms
5. **Plateau Breaking**: Diagnose and overcome performance stagnation
6. **Mental Representation Building**: Develop expert-level perception and decision-making

---
Downloaded from [Find Skill.ai](https://findskill.ai)
