---
name: digital-file-folder-organizer
version: 1.0.0
---

# Initialization

Digital Files & Folder System Organizer - An AI skill for designing sustainable file structures, naming conventions, and safe migration plans. Helps users master PARA method, taxonomies, and metadata tagging to eliminate digital chaos.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with complete instructions for organizing digital files and folders

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r digital-file-folder-organizer/ ~/.claude/skills/digital-file-folder-organizer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (everything below the second `---`)
3. Paste into your AI assistant's system prompt or custom instructions

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Core Capabilities

This skill enables AI assistants to:

1. **Design Custom Folder Hierarchies** - Create project-based, category-based, or role-based structures with proper nesting
2. **Audit Existing File Systems** - Analyze current organization, identify bottlenecks, duplicates, and improvement opportunities
3. **Generate File Naming Conventions** - Design consistent, searchable naming schemes with ISO 8601 dates and version control
4. **Plan Safe Migration Paths** - Create phased transition plans with backup, validation, and rollback procedures
5. **Build Metadata & Tagging Strategies** - Implement multi-dimensional organization beyond folder hierarchy

## Key Frameworks Included

- **PARA Method**: Projects, Areas, Resources, Archives
- **ISO 8601 Date Format**: YYYY-MM-DD for chronological sorting
- **Digital Asset Management (DAM)**: Enterprise-grade organization principles
- **Controlled Vocabulary**: Consistent naming and tagging systems

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{max_folder_depth}}` | `3` | Maximum levels of nesting before recommending consolidation |
| `{{naming_convention_format}}` | `YYYY-MM-DD_ProjectName_Description_vN` | Template for file/folder naming |
| `{{archive_threshold}}` | `12 months` | Time since last modification before suggesting archival |
| `{{date_format}}` | `YYYY-MM-DD` | Date format for filenames (ISO 8601 recommended) |
| `{{separator_character}}` | `_ (underscore)` | Character used between naming elements |

## Example Prompts

**Design a new system:**
"I'm a freelance graphic designer with 8 years of client projects. I need a folder structure that works across Mac, cloud storage, and client handoff."

**Audit existing chaos:**
"My team shares a drive with 60GB of data and no one can find anything. How do I analyze what we have and create standards?"

**Plan safe migration:**
"I want to reorganize my 50GB collection but I'm terrified of losing photos. Walk me through a safe migration process."

## Output Formats

The skill provides structured outputs including:
- Visual folder tree diagrams
- Audit checklists and reports
- Naming convention templates with examples
- Phased migration plans with validation checkpoints
- Metadata schemas with controlled vocabularies

---
Downloaded from [Find Skill.ai](https://findskill.ai)
