---
name: email-bankruptcy-inbox-reset
version: 1.0.0
---

# Email Bankruptcy & Inbox Reset System

Declare email bankruptcy and reset to inbox zero using proven GTD methodology, protected sender logic, and sustainable daily routines. This comprehensive system helps professionals drowning in 1,000-50,000+ emails reclaim their inbox and establish a 17-minute daily maintenance routine.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with email bankruptcy strategies, GTD triage system, filter templates, and daily routines

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None required. Works with any AI assistant.

**Optional enhancements:**
- Gmail account (for Gmail-specific filters and search syntax)
- Outlook account (for Outlook-specific rules)
- Google Apps Script access (for automation scripts)

## Post-Init Steps

### Claude Code
```bash
cp -r email-bankruptcy-inbox-reset/ ~/.claude/skills/email-bankruptcy-inbox-reset/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (starting from "You are an expert...")
3. Paste into your AI assistant as a system prompt or conversation starter

### Recommended Setup
1. Before using this skill, gather:
   - Current unread email count
   - List of protected senders (boss, clients, legal, family)
   - Available time for initial reset (1-4 hours)
   - Email platform (Gmail/Outlook/other)

2. Start conversation with your situation:
   - "I have X,XXX unread emails..."
   - "I just got back from vacation and have..."
   - "My inbox is out of control and..."

## Compatibility

Tested with: Claude, ChatGPT, Gemini, Copilot

**Email Platform Support:**
- Gmail (full support with search syntax and filter templates)
- Outlook (full support with rules and search syntax)
- Apple Mail (basic support)
- Other IMAP clients (basic support)

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{grace_period_days}}` | `30` | Days of recent emails to protect from bankruptcy (7-90) |
| `{{protected_senders}}` | `boss@, legal@, @company.com` | Email addresses/domains never archived |
| `{{batch_frequency}}` | `3` | Email processing sessions per day (1-4) |
| `{{archive_threshold_days}}` | `180` | Emails older than this targeted for bankruptcy |
| `{{label_system}}` | `@ACTION, @WAITING, @REFERENCE` | GTD labels to create |
| `{{response_sla}}` | `24 hours` | Promised response time for bankruptcy notification |

## Core Workflows

### 1. Full Email Bankruptcy
For users with 3,000-50,000+ emails:
- Risk assessment and compliance check
- Protected sender configuration
- Grace period setup (30 days recommended)
- Bulk archive execution
- Professional notification to contacts
- GTD system implementation

### 2. Soft Reset
For users with 500-2,000 emails:
- Phased archiving by age/type
- Selective preservation of important threads
- Newsletter and notification cleanup
- Foundation for sustainable system

### 3. Post-Vacation Recovery
For users returning from extended leave:
- Priority triage matrix
- Emergency scan for fires
- Age-based processing (newest first)
- Recovery communication template

### 4. Daily Maintenance
17-minute system for ongoing management:
- Morning scan (7 min)
- Midday processing (5 min)
- End-of-day sweep (5 min)
- Weekly review (15 min Friday)

## Expected Outcomes

After implementing this skill:
- Inbox reduced to <50 emails (or zero)
- Daily email time reduced from 2-3 hours to 17 minutes
- 495+ hours saved annually
- Reduced email anxiety and decision fatigue
- Sustainable system preventing re-accumulation

## Research Sources

This skill synthesizes methodologies from:
- David Allen's Getting Things Done (GTD)
- Tiago Forte's C.O.D.E. framework and One-Touch Inbox Zero
- Inbox Zero open-source project
- McKinsey research on professional email habits
- Google Apps Script automation patterns

---
Downloaded from [Find Skill.ai](https://findskill.ai)
