---
name: email-message-composer
version: 1.0.0
description: Universal writing assistant for emails, messages, and difficult conversations
author: FindSkill.ai
license: MIT
---

# Initialization

The universal writing assistant for any email, message, or difficult conversation. Research shows 19% of US adults already use AI for email writing - this skill makes you one of them.

## Overview

This is a prompt-only skill that helps users draft, edit, and refine any type of written communication. No scripts or additional files are required.

**Time to initialize**: Instant (no setup required)

## Directory Structure

```
email-message-composer/
├── SKILL.md    # Main skill prompt
└── INIT.md     # This file
```

## Dependencies

None - this is a prompt-only skill.

## Files to Generate

None - simply use SKILL.md directly.

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r email-message-composer/ ~/.claude/skills/email-message-composer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: Claude, ChatGPT, Gemini, Copilot

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `message_type` | email | Type of message (email, text, LinkedIn, letter) |
| `recipient` | (empty) | Who the message is for |
| `purpose` | (empty) | What you want to communicate |
| `tone` | professional | Desired tone (formal, friendly, assertive, apologetic) |
| `context` | (empty) | Background information or relationship context |

## Use Cases

This skill excels at:

### Professional Communication
- Job application follow-ups
- Salary negotiation emails
- Client proposals and updates
- Internal team announcements
- Networking and introduction requests

### Personal Communication
- Emails to teachers about your child
- Messages to landlords about issues
- Difficult family communications
- Reconnecting with old friends
- RSVPs and event coordination

### Difficult Situations
- Complaint letters that get results
- Refund and exception requests
- Declining invitations gracefully
- Setting boundaries with family
- Apologizing sincerely

### Non-Native English Speakers
- Making messages sound natural
- Choosing the right formality level
- Understanding cultural communication norms
- Avoiding common language pitfalls

## Example Outputs

**Input**: "I need to tell my boss I'm quitting but I like them and don't want to burn bridges"

**Output**: A professionally worded resignation email that expresses gratitude, provides appropriate notice, and maintains the relationship.

**Input**: "My neighbor's dog barks all night and I'm losing sleep but I don't want to start a war"

**Output**: A friendly but clear message that addresses the issue, assumes good intent, and proposes solutions.

---
Downloaded from [FindSkill.ai](https://findskill.ai)
