---
name: emergency-fund-calculator
version: 1.0.0
---

# Initialization

Emergency Fund Calculator - Calculate your personalized emergency fund size based on income stability, expenses, dependents, and risk factors. Move beyond generic "3-6 months" advice to find the right target for YOUR situation.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive emergency fund calculation framework

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r emergency-fund-calculator/ ~/.claude/skills/emergency-fund-calculator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (everything after the second `---`)
3. Paste into your AI assistant's system prompt or custom instructions

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Core Capabilities

1. **Personalized Fund Calculation** - Determine exact dollar amount based on essential expenses, income stability, and risk factors
2. **Income Volatility Assessment** - Adjust targets for freelancers, contractors, and gig workers
3. **Scenario Stress-Testing** - Model job loss, major expenses, and dual crises
4. **Investment Permission Framework** - Guide when/how to invest excess savings safely
5. **Life Change Reassessment** - Recalculate after major life events

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{essential_expense_monthly}}` | `3000` | Monthly essential expenses |
| `{{income_stability_score}}` | `moderate` | Job security level (stable/moderate/volatile) |
| `{{household_income_earners}}` | `1` | Number of income earners in household |
| `{{dependent_count}}` | `0` | Number of financial dependents |
| `{{current_emergency_fund_balance}}` | `0` | Current emergency savings balance |
| `{{psychological_comfort_threshold}}` | `null` | Override for personal comfort level |

## Example Usage

**Input:**
```
I'm a software engineer at a tech company earning $140,000. My spouse is a nurse earning $65,000. We have two kids, mortgage $2,200/month, utilities $400, childcare $1,200, groceries $600, transportation $300. We have $8,000 saved. How much emergency fund do we need?
```

**Expected Output:**
- Calculated essential monthly expenses: $4,900
- Risk profile assessment with adjustments
- Target emergency fund: ~$29,400 (6 months for dual income with dependents)
- Gap analysis: $21,400 needed
- Monthly savings plan options (12/18/24 month timelines)
- Storage recommendations (HYSA)

## Key Formulas

```
Essential Monthly Expenses = Housing + Utilities + Insurance + Groceries + Transportation + Minimum Debt + Childcare

Base Months:
- Dual income, no dependents: 3 months
- Dual income, with dependents: 4 months
- Single income, no dependents: 4 months
- Single income, with dependents: 6 months

Adjustments:
+ Self-employed: +2-3 months
+ Variable income: +1-2 months
+ Specialized job: +1 month
- In-demand skills: -1 month
- Government job: -1 month

Target = Essential Expenses × Adjusted Months
Gap = Target - Current Balance
Monthly Savings = Gap ÷ Timeline (12-24 months)
```

## Storage Recommendations

- **Core fund (80%)**: High-Yield Savings Account (4-5% APY)
- **Excess (20%)**: Treasury bills or short-term CD ladder
- **Never**: Stocks, crypto, checking accounts

---
Downloaded from [Find Skill.ai](https://findskill.ai)
