---
name: family-event-organizer
version: 1.0.0
description: AI-powered family event planning assistant for birthday parties, scavenger hunts, packing lists, and schedule coordination
author: FindSkill.ai
license: MIT
---

# Initialization

This skill helps busy parents plan birthday parties, generate scavenger hunts, create travel packing lists, coordinate family schedules, and manage RSVPs efficiently.

## Overview

The Family Event Organizer is a prompt-only skill that transforms any AI assistant into a comprehensive family event planning helper. It provides structured templates and age-appropriate activity guidance.

**Time to initialize**: ~1 minute

## Directory Structure

```
family-event-organizer/
├── SKILL.md          # Main skill prompt with planning templates
└── INIT.md           # This initialization file
```

## Dependencies

None - this is a prompt-only skill.

## Files to Generate

None - copy SKILL.md content directly to your AI assistant.

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r family-event-organizer/ ~/.claude/skills/family-event-organizer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

Customize these placeholders in conversations:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{child_age}}` | `8` | Age of child for age-appropriate activities |
| `{{event_type}}` | `birthday party` | Type of family event |
| `{{guest_count}}` | `12` | Number of expected guests |
| `{{trip_destination}}` | `beach vacation` | Destination for travel packing lists |
| `{{budget}}` | `moderate` | Budget range for the event |

## Example Usage

### Birthday Party Planning
```
My daughter is turning 7 next month. We want a unicorn-themed birthday
party at home for 15 kids. Can you help me plan everything - activities,
decorations, food, and a scavenger hunt? Budget is around $300.
```

### Travel Packing List
```
We're taking a 5-day beach vacation to Florida with our kids ages 4 and 8.
Create a comprehensive packing list for our family of 4.
```

### Scavenger Hunt
```
Create an outdoor scavenger hunt for my son's 10th birthday party.
Theme is "Explorer Adventure" and we have 12 kids coming.
```

### Schedule Coordination
```
Help me organize our family's weekly schedule. We have 2 kids in
different sports and activities, and both parents work full-time.
```

## Features

- **Birthday Party Planning**: Complete timelines, shopping lists, activity ideas, and budget tracking
- **Scavenger Hunt Generator**: Age-appropriate riddles, clues, and challenges for any theme
- **Travel Packing Lists**: Comprehensive lists organized by family member and activity
- **Schedule Coordination**: Weekly family calendar with carpool and meal planning
- **RSVP Management**: Guest tracking with dietary accommodations

## Age-Appropriate Guidelines Built-In

The skill automatically adjusts recommendations based on children's ages:
- Ages 3-5: Simple activities, picture-based hunts, short attention spans
- Ages 6-8: Team games, simple riddles, moderate complexity
- Ages 9-12: Photo challenges, complex puzzles, longer activities
- Ages 13+: Tech integration, social media elements, sophisticated themes

---
Downloaded from [Find Skill.ai](https://findskill.ai)
