---
name: family-meal-planner-recipes
version: 1.0.0
description: Create weekly family meal plans with full recipes, step-by-step cooking instructions, and shopping lists organized by store section
author: FindSkill.ai
license: MIT
---

# Initialization

A comprehensive meal planning assistant designed for families with mixed dietary needs, picky eaters, and budget constraints. Generates complete recipes with step-by-step instructions and shopping lists organized by store section.

## Overview

This is a prompt-only skill. Simply copy the content from SKILL.md and paste it into your AI assistant.

**Time to initialize**: ~1 minute

## Directory Structure

```
family-meal-planner-recipes/
├── SKILL.md    # Main skill instructions (copy this)
└── INIT.md     # This initialization file
```

## Dependencies

None - this is a prompt-only skill.

## Files to Generate

None - all content is in SKILL.md.

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r family-meal-planner-recipes/ ~/.claude/skills/family-meal-planner-recipes/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: Claude, ChatGPT, Gemini, Copilot

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{household_size}}` | `4` | Number of people in household |
| `{{weekly_budget}}` | `$150` | Weekly grocery budget |
| `{{cooking_time}}` | `30 minutes` | Available cooking time on weeknights |
| `{{dietary_restrictions}}` | `none` | Any allergies or dietary requirements |

## Key Features

### Family-Focused
- Handles multiple dietary requirements in one household
- Kid-friendly adaptations for picky eaters
- Age-appropriate portions and preferences

### Complete Recipes
- Full step-by-step cooking instructions
- Prep time, cook time, and total time
- Chef tips and common mistakes to avoid
- Make-ahead and freezer-friendly options

### Organized Shopping
- Lists grouped by store section
- Consolidated ingredients across recipes
- Cost estimates per item and total
- Pantry staple flags

### Budget Tracking
- Per-serving cost targets
- Weekly budget monitoring
- Money-saving substitution suggestions

## Example Usage

```
Create a weekly meal plan for my family of 5. We have two picky eaters (ages 6 and 9), one vegetarian teenager, and two adults who eat everything. Budget is $175/week. I have 30 minutes max for weeknight dinners but can cook longer on weekends. We're trying to reduce red meat. Give me full recipes and organize my shopping list by store section.
```

---
Downloaded from [Find Skill.ai](https://findskill.ai)
