---
name: financial-stress-cycle-breaker
version: 1.0.0
---

# Financial Stress Cycle Breaker - Initialization

Break the vicious feedback loop where financial stress causes poor decisions that worsen your financial situation, creating more stress. This trauma-informed skill uses polyvagal theory, systems thinking, and behavioral science to help you map your personal stress cycles, regulate your nervous system before financial decisions, and design environmental changes that work without relying on willpower.

## What This Skill Does

This skill transforms your relationship with money stress by:

1. **Mapping your personal cycle** - Identifying the specific trigger → stress response → poor decision → consequence → more stress pattern unique to you

2. **Assessing your nervous system state** - Understanding whether you respond to financial stress with fight (recklessness), flight (avoidance), freeze (paralysis), or fawn (people-pleasing)

3. **Building regulation capacity** - Learning techniques to calm your nervous system BEFORE making financial decisions

4. **Designing interruption systems** - Creating environmental changes that automatically prevent stress-driven decisions without requiring willpower

5. **Integrating across life domains** - Addressing the interconnected spirals between mental health, physical health, work, and finances

## Structure

This skill contains:
- `SKILL.md` - Complete skill prompt with all instructions, frameworks, and templates

## Files to Generate

None required. This is a prompt-only skill - copy the content from SKILL.md directly into your AI assistant.

## Dependencies

None.

## Post-Init Steps

### For Claude Code Users
```bash
# Copy to your Claude Code skills directory
cp -r financial-stress-cycle-breaker/ ~/.claude/skills/financial-stress-cycle-breaker/
```

### For Other AI Assistants (ChatGPT, Gemini, Copilot)
1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or custom instructions
4. Begin a conversation describing your financial stress situation

## Compatibility

Tested and working with:
- Claude (claude.ai, Claude Code)
- ChatGPT (GPT-4, GPT-4o)
- Gemini (Gemini Pro, Gemini Advanced)
- Copilot (Microsoft Copilot)

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `stress_response_type` | `freeze` | Your dominant nervous system response when facing finances: fight (reckless), flight (avoidance), freeze (paralysis), fawn (people-pleasing) |
| `regulation_window_minutes` | `10` | Time needed to shift from dysregulated to regulated state before financial decisions |
| `primary_stress_trigger` | `unexpected_expense` | Most frequent stressor activating your cycle: unexpected_expense, debt_awareness, income_volatility, health_crisis, relationship_conflict |
| `impulse_control_difficulty` | `high` | Severity of impulse spending under stress: low, medium, high, extreme |
| `accountability_preference` | `self_tracking` | Preferred accountability method: self_tracking, peer, professional, group |
| `mental_health_status` | `stressed` | Current mental health baseline: healthy, stressed, managing_depression_anxiety, crisis |
| `behavior_change_readiness` | `contemplation` | Transtheoretical stage: precontemplation, contemplation, preparation, action, maintenance |

## Example Usage

**Getting Started**:
```
"I have a problem where I avoid opening bills because they stress me out,
then after a few weeks I panic and spend money I don't have to feel better
temporarily, but then the bills are even worse. I feel stuck in this loop.
Can you help me understand what's happening and break this cycle?"
```

**For Emotional Spending**:
```
"Every time work is stressful, I come home and buy things online. It's
become a coping mechanism. I have $5k in credit card debt and I know I'm
making things worse. I don't want to rely on willpower because it fails
when I'm stressed. Can we design a system that makes it impossible to do
this without feeling deprived?"
```

**For Multi-Domain Issues**:
```
"I'm in this nightmare cycle. I have depression so I don't work as much.
Income drops, which stresses my partner, which makes my depression worse.
I avoid looking at finances, so debt grows. Everything is connected and
I don't know where to start."
```

## Key Frameworks

### The Stress Cycle
```
Trigger → Stress Response → Impaired Decisions → Poor Choice →
Worse Situation → More Stress → (cycle repeats)
```

### The 70/20/10 Principle
- 70% system/environment design (no willpower needed)
- 20% skill building (regulation techniques)
- 10% motivation/knowledge

### Polyvagal States
- **Ventral Vagal (Safe)**: Can think clearly, face reality
- **Sympathetic (Threat)**: Fight or flight, reckless or avoidant
- **Dorsal Vagal (Shutdown)**: Freeze or fawn, paralyzed or people-pleasing

## When to Seek Professional Help

This skill is educational guidance, not therapy or financial advice. Seek professional support if you experience:
- Persistent depression or anxiety affecting daily function
- Suicidal thoughts related to financial stress
- Financial abuse in relationships
- Severe trauma responses that don't improve
- Complex debt situations requiring legal/financial expertise

## Related Skills

- **Money Anxiety Decoder** - Diagnose specific anxiety patterns
- **Cognitive Reframing Guide** - CBT techniques for thought patterns
- **Emotional Regulation Coach** - Evidence-based emotional management
- **Debt Elimination Sequencer** - Behavioral science for debt payoff
- **Habit Tracker** - Build and break habits systematically

---
Downloaded from [Find Skill.ai](https://findskill.ai)
